package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentMemoryState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentPowerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentState.Type;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentTempState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.memory.state.Memory;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.temp.state.Temperature;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.types.rev210118.COMPONENTOPERSTATUS;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Date;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private Uint32 _allocatedPower;
    private String _description;
    private Boolean _empty;
    private String _firmwareVersion;
    private String _hardwareVersion;
    private String _id;
    private String _location;
    private Memory _memory;
    private Date _mfgDate;
    private String _mfgName;
    private String _name;
    private Class<? extends COMPONENTOPERSTATUS> _operStatus;
    private String _parent;
    private String _partNo;
    private Boolean _removable;
    private String _serialNo;
    private String _softwareVersion;
    private Temperature _temperature;
    private Type _type;
    private Uint32 _usedPower;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }
    
    
    
    public StateBuilder(PlatformComponentConfig arg) {
        this._name = arg.getName();
    }
    
    public StateBuilder(PlatformComponentState arg) {
        this._type = arg.getType();
        this._id = arg.getId();
        this._location = arg.getLocation();
        this._description = arg.getDescription();
        this._mfgName = arg.getMfgName();
        this._mfgDate = arg.getMfgDate();
        this._hardwareVersion = arg.getHardwareVersion();
        this._firmwareVersion = arg.getFirmwareVersion();
        this._softwareVersion = arg.getSoftwareVersion();
        this._serialNo = arg.getSerialNo();
        this._partNo = arg.getPartNo();
        this._removable = arg.getRemovable();
        this._operStatus = arg.getOperStatus();
        this._empty = arg.getEmpty();
        this._parent = CodeHelpers.checkFieldCast(String.class, "parent", arg.getParent());
    }
    
    public StateBuilder(PlatformComponentTempState arg) {
        this._temperature = arg.getTemperature();
    }
    
    public StateBuilder(PlatformComponentMemoryState arg) {
        this._memory = arg.getMemory();
    }
    
    public StateBuilder(PlatformComponentPowerState arg) {
        this._allocatedPower = arg.getAllocatedPower();
        this._usedPower = arg.getUsedPower();
    }

    public StateBuilder(State base) {
        Map<Class<? extends Augmentation<State>>, Augmentation<State>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._allocatedPower = base.getAllocatedPower();
        this._description = base.getDescription();
        this._empty = base.getEmpty();
        this._firmwareVersion = base.getFirmwareVersion();
        this._hardwareVersion = base.getHardwareVersion();
        this._id = base.getId();
        this._location = base.getLocation();
        this._memory = base.getMemory();
        this._mfgDate = base.getMfgDate();
        this._mfgName = base.getMfgName();
        this._name = base.getName();
        this._operStatus = base.getOperStatus();
        this._parent = base.getParent();
        this._partNo = base.getPartNo();
        this._removable = base.getRemovable();
        this._serialNo = base.getSerialNo();
        this._softwareVersion = base.getSoftwareVersion();
        this._temperature = base.getTemperature();
        this._type = base.getType();
        this._usedPower = base.getUsedPower();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>PlatformComponentTempState</li>
     * <li>PlatformComponentMemoryState</li>
     * <li>PlatformComponentPowerState</li>
     * <li>PlatformComponentConfig</li>
     * <li>PlatformComponentState</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PlatformComponentTempState) {
            this._temperature = ((PlatformComponentTempState)arg).getTemperature();
            isValidArg = true;
        }
        if (arg instanceof PlatformComponentMemoryState) {
            this._memory = ((PlatformComponentMemoryState)arg).getMemory();
            isValidArg = true;
        }
        if (arg instanceof PlatformComponentPowerState) {
            this._allocatedPower = ((PlatformComponentPowerState)arg).getAllocatedPower();
            this._usedPower = ((PlatformComponentPowerState)arg).getUsedPower();
            isValidArg = true;
        }
        if (arg instanceof PlatformComponentConfig) {
            this._name = ((PlatformComponentConfig)arg).getName();
            isValidArg = true;
        }
        if (arg instanceof PlatformComponentState) {
            this._type = ((PlatformComponentState)arg).getType();
            this._id = ((PlatformComponentState)arg).getId();
            this._location = ((PlatformComponentState)arg).getLocation();
            this._description = ((PlatformComponentState)arg).getDescription();
            this._mfgName = ((PlatformComponentState)arg).getMfgName();
            this._mfgDate = ((PlatformComponentState)arg).getMfgDate();
            this._hardwareVersion = ((PlatformComponentState)arg).getHardwareVersion();
            this._firmwareVersion = ((PlatformComponentState)arg).getFirmwareVersion();
            this._softwareVersion = ((PlatformComponentState)arg).getSoftwareVersion();
            this._serialNo = ((PlatformComponentState)arg).getSerialNo();
            this._partNo = ((PlatformComponentState)arg).getPartNo();
            this._removable = ((PlatformComponentState)arg).getRemovable();
            this._operStatus = ((PlatformComponentState)arg).getOperStatus();
            this._empty = ((PlatformComponentState)arg).getEmpty();
            this._parent = CodeHelpers.checkFieldCast(String.class, "parent", ((PlatformComponentState)arg).getParent());
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PlatformComponentTempState, PlatformComponentMemoryState, PlatformComponentPowerState, PlatformComponentConfig, PlatformComponentState]");
    }

    public Uint32 getAllocatedPower() {
        return _allocatedPower;
    }
    
    public String getDescription() {
        return _description;
    }
    
    public Boolean getEmpty() {
        return _empty;
    }
    
    public String getFirmwareVersion() {
        return _firmwareVersion;
    }
    
    public String getHardwareVersion() {
        return _hardwareVersion;
    }
    
    public String getId() {
        return _id;
    }
    
    public String getLocation() {
        return _location;
    }
    
    public Memory getMemory() {
        return _memory;
    }
    
    public Date getMfgDate() {
        return _mfgDate;
    }
    
    public String getMfgName() {
        return _mfgName;
    }
    
    public String getName() {
        return _name;
    }
    
    public Class<? extends COMPONENTOPERSTATUS> getOperStatus() {
        return _operStatus;
    }
    
    public String getParent() {
        return _parent;
    }
    
    public String getPartNo() {
        return _partNo;
    }
    
    public Boolean getRemovable() {
        return _removable;
    }
    
    public String getSerialNo() {
        return _serialNo;
    }
    
    public String getSoftwareVersion() {
        return _softwareVersion;
    }
    
    public Temperature getTemperature() {
        return _temperature;
    }
    
    public Type getType() {
        return _type;
    }
    
    public Uint32 getUsedPower() {
        return _usedPower;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public StateBuilder setAllocatedPower(final Uint32 value) {
        this._allocatedPower = value;
        return this;
    }
    
    public StateBuilder setDescription(final String value) {
        this._description = value;
        return this;
    }
    
    public StateBuilder setEmpty(final Boolean value) {
        this._empty = value;
        return this;
    }
    
    public StateBuilder setFirmwareVersion(final String value) {
        this._firmwareVersion = value;
        return this;
    }
    
    public StateBuilder setHardwareVersion(final String value) {
        this._hardwareVersion = value;
        return this;
    }
    
    public StateBuilder setId(final String value) {
        this._id = value;
        return this;
    }
    
    public StateBuilder setLocation(final String value) {
        this._location = value;
        return this;
    }
    
    public StateBuilder setMemory(final Memory value) {
        this._memory = value;
        return this;
    }
    
    public StateBuilder setMfgDate(final Date value) {
        this._mfgDate = value;
        return this;
    }
    
    public StateBuilder setMfgName(final String value) {
        this._mfgName = value;
        return this;
    }
    
    public StateBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    public StateBuilder setOperStatus(final Class<? extends COMPONENTOPERSTATUS> value) {
        this._operStatus = value;
        return this;
    }
    
    public StateBuilder setParent(final String value) {
        this._parent = value;
        return this;
    }
    
    public StateBuilder setPartNo(final String value) {
        this._partNo = value;
        return this;
    }
    
    public StateBuilder setRemovable(final Boolean value) {
        this._removable = value;
        return this;
    }
    
    public StateBuilder setSerialNo(final String value) {
        this._serialNo = value;
        return this;
    }
    
    public StateBuilder setSoftwareVersion(final String value) {
        this._softwareVersion = value;
        return this;
    }
    
    public StateBuilder setTemperature(final Temperature value) {
        this._temperature = value;
        return this;
    }
    
    public StateBuilder setType(final Type value) {
        this._type = value;
        return this;
    }
    
    public StateBuilder setUsedPower(final Uint32 value) {
        this._usedPower = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class<? extends Augmentation<State>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final Uint32 _allocatedPower;
        private final String _description;
        private final Boolean _empty;
        private final String _firmwareVersion;
        private final String _hardwareVersion;
        private final String _id;
        private final String _location;
        private final Memory _memory;
        private final Date _mfgDate;
        private final String _mfgName;
        private final String _name;
        private final Class<? extends COMPONENTOPERSTATUS> _operStatus;
        private final String _parent;
        private final String _partNo;
        private final Boolean _removable;
        private final String _serialNo;
        private final String _softwareVersion;
        private final Temperature _temperature;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentState.Type _type;
        private final Uint32 _usedPower;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._allocatedPower = base.getAllocatedPower();
            this._description = base.getDescription();
            this._empty = base.getEmpty();
            this._firmwareVersion = base.getFirmwareVersion();
            this._hardwareVersion = base.getHardwareVersion();
            this._id = base.getId();
            this._location = base.getLocation();
            this._memory = base.getMemory();
            this._mfgDate = base.getMfgDate();
            this._mfgName = base.getMfgName();
            this._name = base.getName();
            this._operStatus = base.getOperStatus();
            this._parent = base.getParent();
            this._partNo = base.getPartNo();
            this._removable = base.getRemovable();
            this._serialNo = base.getSerialNo();
            this._softwareVersion = base.getSoftwareVersion();
            this._temperature = base.getTemperature();
            this._type = base.getType();
            this._usedPower = base.getUsedPower();
        }
    
        @Override
        public Uint32 getAllocatedPower() {
            return _allocatedPower;
        }
        
        @Override
        public String getDescription() {
            return _description;
        }
        
        @Override
        public Boolean getEmpty() {
            return _empty;
        }
        
        @Override
        public String getFirmwareVersion() {
            return _firmwareVersion;
        }
        
        @Override
        public String getHardwareVersion() {
            return _hardwareVersion;
        }
        
        @Override
        public String getId() {
            return _id;
        }
        
        @Override
        public String getLocation() {
            return _location;
        }
        
        @Override
        public Memory getMemory() {
            return _memory;
        }
        
        @Override
        public Date getMfgDate() {
            return _mfgDate;
        }
        
        @Override
        public String getMfgName() {
            return _mfgName;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public Class<? extends COMPONENTOPERSTATUS> getOperStatus() {
            return _operStatus;
        }
        
        @Override
        public String getParent() {
            return _parent;
        }
        
        @Override
        public String getPartNo() {
            return _partNo;
        }
        
        @Override
        public Boolean getRemovable() {
            return _removable;
        }
        
        @Override
        public String getSerialNo() {
            return _serialNo;
        }
        
        @Override
        public String getSoftwareVersion() {
            return _softwareVersion;
        }
        
        @Override
        public Temperature getTemperature() {
            return _temperature;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentState.Type getType() {
            return _type;
        }
        
        @Override
        public Uint32 getUsedPower() {
            return _usedPower;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
