package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformAnchorsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentPropertiesTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformSubcomponentRefTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.Components;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component.State;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * List of components, keyed by component name.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * list component {
 *   key name;
 *   leaf name {
 *     type leafref {
 *       path ../config/name;
 *     }
 *   }
 *   container config {
 *     uses platform-component-config;
 *   }
 *   container state {
 *     config false;
 *     uses platform-component-config;
 *     uses platform-component-state;
 *     uses platform-component-temp-state;
 *     uses platform-component-memory-state;
 *     uses platform-component-power-state;
 *   }
 *   uses platform-component-properties-top;
 *   uses platform-subcomponent-ref-top;
 *   uses platform-anchors-top;
 * }
 * </pre>
 * <p>To create instances of this class use {@link ComponentBuilder}.
 * @see ComponentBuilder
 * @see ComponentKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Component
    extends
    ChildOf<Components>,
    Augmentable<Component>,
    PlatformComponentPropertiesTop,
    PlatformSubcomponentRefTop,
    PlatformAnchorsTop,
    Identifiable<ComponentKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("component");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.Component> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.Component.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.@NonNull Component obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getBackplane());
        result = prime * result + Objects.hashCode(obj.getChassis());
        result = prime * result + Objects.hashCode(obj.getConfig());
        result = prime * result + Objects.hashCode(obj.getCpu());
        result = prime * result + Objects.hashCode(obj.getFabric());
        result = prime * result + Objects.hashCode(obj.getFan());
        result = prime * result + Objects.hashCode(obj.getIntegratedCircuit());
        result = prime * result + Objects.hashCode(obj.getName());
        result = prime * result + Objects.hashCode(obj.getPort());
        result = prime * result + Objects.hashCode(obj.getPowerSupply());
        result = prime * result + Objects.hashCode(obj.getProperties());
        result = prime * result + Objects.hashCode(obj.getSoftwareModule());
        result = prime * result + Objects.hashCode(obj.getState());
        result = prime * result + Objects.hashCode(obj.getStorage());
        result = prime * result + Objects.hashCode(obj.getSubcomponents());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.@NonNull Component thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.Component other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.Component.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(thisObj.getBackplane(), other.getBackplane())) {
            return false;
        }
        if (!Objects.equals(thisObj.getChassis(), other.getChassis())) {
            return false;
        }
        if (!Objects.equals(thisObj.getConfig(), other.getConfig())) {
            return false;
        }
        if (!Objects.equals(thisObj.getCpu(), other.getCpu())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFabric(), other.getFabric())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFan(), other.getFan())) {
            return false;
        }
        if (!Objects.equals(thisObj.getIntegratedCircuit(), other.getIntegratedCircuit())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPort(), other.getPort())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPowerSupply(), other.getPowerSupply())) {
            return false;
        }
        if (!Objects.equals(thisObj.getProperties(), other.getProperties())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSoftwareModule(), other.getSoftwareModule())) {
            return false;
        }
        if (!Objects.equals(thisObj.getState(), other.getState())) {
            return false;
        }
        if (!Objects.equals(thisObj.getStorage(), other.getStorage())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSubcomponents(), other.getSubcomponents())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.@NonNull Component obj) {
        final var helper = MoreObjects.toStringHelper("Component");
        CodeHelpers.appendValue(helper, "backplane", obj.getBackplane());
        CodeHelpers.appendValue(helper, "chassis", obj.getChassis());
        CodeHelpers.appendValue(helper, "config", obj.getConfig());
        CodeHelpers.appendValue(helper, "cpu", obj.getCpu());
        CodeHelpers.appendValue(helper, "fabric", obj.getFabric());
        CodeHelpers.appendValue(helper, "fan", obj.getFan());
        CodeHelpers.appendValue(helper, "integratedCircuit", obj.getIntegratedCircuit());
        CodeHelpers.appendValue(helper, "name", obj.getName());
        CodeHelpers.appendValue(helper, "port", obj.getPort());
        CodeHelpers.appendValue(helper, "powerSupply", obj.getPowerSupply());
        CodeHelpers.appendValue(helper, "properties", obj.getProperties());
        CodeHelpers.appendValue(helper, "softwareModule", obj.getSoftwareModule());
        CodeHelpers.appendValue(helper, "state", obj.getState());
        CodeHelpers.appendValue(helper, "storage", obj.getStorage());
        CodeHelpers.appendValue(helper, "subcomponents", obj.getSubcomponents());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    ComponentKey key();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         References the component name
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         References the component name
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return config, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Configuration data for each component
     *     </code>
     * </pre>
     *
     * @return {@code Config} config, or {@code null} if it is not present.
     *
     */
    Config getConfig();
    
    /**
     * Return state, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Operational state data for each component
     *     </code>
     * </pre>
     *
     * @return {@code State} state, or {@code null} if it is not present.
     *
     */
    State getState();

}

