package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.Component;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.ComponentKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link Components} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Components createComponents(int fooXyzzy, int barBaz) {
 *         return new ComponentsBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Components, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Components
 *
 */
@Generated("mdsal-binding-generator")
public class ComponentsBuilder {

    private Map<ComponentKey, Component> _component;


    Map<Class<? extends Augmentation<Components>>, Augmentation<Components>> augmentation = Collections.emptyMap();

    public ComponentsBuilder() {
    }
    
    

    public ComponentsBuilder(Components base) {
        Map<Class<? extends Augmentation<Components>>, Augmentation<Components>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._component = base.getComponent();
    }


    public Map<ComponentKey, Component> getComponent() {
        return _component;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Components>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ComponentsBuilder setComponent(final Map<ComponentKey, Component> values) {
        this._component = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ComponentsBuilder addAugmentation(Augmentation<Components> augmentation) {
        Class<? extends Augmentation<Components>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ComponentsBuilder removeAugmentation(Class<? extends Augmentation<Components>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Components} instance.
     *
     * @return A new {@link Components} instance.
     */
    public Components build() {
        return new ComponentsImpl(this);
    }

    private static final class ComponentsImpl
        extends AbstractAugmentable<Components>
        implements Components {
    
        private final Map<ComponentKey, Component> _component;
    
        ComponentsImpl(ComponentsBuilder base) {
            super(base.augmentation);
            this._component = CodeHelpers.emptyToNull(base.getComponent());
        }
    
        @Override
        public Map<ComponentKey, Component> getComponent() {
            return _component;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Components.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Components.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Components.bindingToString(this);
        }
    }
}
