package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.properties;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.properties.property.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.properties.property.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Property} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Property createProperty(int fooXyzzy, int barBaz) {
 *         return new PropertyBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Property, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Property
 *
 */
@Generated("mdsal-binding-generator")
public class PropertyBuilder {

    private Config _config;
    private String _name;
    private State _state;
    private PropertyKey key;


    Map<Class<? extends Augmentation<Property>>, Augmentation<Property>> augmentation = Collections.emptyMap();

    public PropertyBuilder() {
    }
    
    
    

    public PropertyBuilder(Property base) {
        Map<Class<? extends Augmentation<Property>>, Augmentation<Property>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._config = base.getConfig();
        this._state = base.getState();
    }


    public PropertyKey key() {
        return key;
    }
    
    public Config getConfig() {
        return _config;
    }
    
    public String getName() {
        return _name;
    }
    
    public State getState() {
        return _state;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Property>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PropertyBuilder withKey(final PropertyKey key) {
        this.key = key;
        return this;
    }
    
    public PropertyBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    public PropertyBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    public PropertyBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PropertyBuilder addAugmentation(Augmentation<Property> augmentation) {
        Class<? extends Augmentation<Property>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PropertyBuilder removeAugmentation(Class<? extends Augmentation<Property>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Property} instance.
     *
     * @return A new {@link Property} instance.
     */
    public Property build() {
        return new PropertyImpl(this);
    }

    private static final class PropertyImpl
        extends AbstractAugmentable<Property>
        implements Property {
    
        private final Config _config;
        private final String _name;
        private final State _state;
        private final PropertyKey key;
    
        PropertyImpl(PropertyBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new PropertyKey(base.getName());
            }
            this._name = key.getName();
            this._config = base.getConfig();
            this._state = base.getState();
        }
    
        @Override
        public PropertyKey key() {
            return key;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Property.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Property.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Property.bindingToString(this);
        }
    }
}
