package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.Subcomponents;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for list of subcomponent references
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * grouping platform-subcomponent-ref-top {
 *   container subcomponents {
 *     list subcomponent {
 *       key name;
 *       leaf name {
 *         type leafref {
 *           path ../config/name;
 *         }
 *       }
 *       container config {
 *         uses platform-subcomponent-ref-config;
 *       }
 *       container state {
 *         config false;
 *         uses platform-subcomponent-ref-config;
 *         uses platform-subcomponent-ref-state;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface PlatformSubcomponentRefTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("platform-subcomponent-ref-top");

    @Override
    Class<? extends PlatformSubcomponentRefTop> implementedInterface();
    
    /**
     * Return subcomponents, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for subcomponent references
     *     </code>
     * </pre>
     *
     * @return {@code Subcomponents} subcomponents, or {@code null} if it is not present.
     *
     */
    Subcomponents getSubcomponents();

}

