package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.types.rev181121.OPENCONFIGALARMSEVERITY;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Temperature alarm data for platform components
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * grouping platform-component-temp-alarm-state {
 *   leaf alarm-status {
 *     type boolean;
 *   }
 *   leaf alarm-threshold {
 *     type uint32;
 *   }
 *   leaf alarm-severity {
 *     type identityref {
 *       base OPENCONFIG_ALARM_SEVERITY;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface PlatformComponentTempAlarmState
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("platform-component-temp-alarm-state");

    @Override
    Class<? extends PlatformComponentTempAlarmState> implementedInterface();
    
    /**
     * Return alarmStatus, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A value of true indicates the alarm has been raised or asserted. The value
     *         should be false when the alarm is cleared.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} alarmStatus, or {@code null} if it is not present.
     *
     */
    Boolean getAlarmStatus();
    
    /**
     * Return alarmStatus, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         A value of true indicates the alarm has been raised or asserted. The value
     *         should be false when the alarm is cleared.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} alarmStatus, guaranteed to be non-null.
     * @throws NoSuchElementException if alarmStatus is not present
     *
     */
    default @NonNull Boolean requireAlarmStatus() {
        return CodeHelpers.require(getAlarmStatus(), "alarmstatus");
    }
    
    /**
     * Return alarmThreshold, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The threshold value that was crossed for this alarm.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} alarmThreshold, or {@code null} if it is not present.
     *
     */
    Uint32 getAlarmThreshold();
    
    /**
     * Return alarmThreshold, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The threshold value that was crossed for this alarm.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} alarmThreshold, guaranteed to be non-null.
     * @throws NoSuchElementException if alarmThreshold is not present
     *
     */
    default @NonNull Uint32 requireAlarmThreshold() {
        return CodeHelpers.require(getAlarmThreshold(), "alarmthreshold");
    }
    
    /**
     * Return alarmSeverity, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The severity of the current alarm.
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends OPENCONFIGALARMSEVERITY>} alarmSeverity, or {@code null} if it is not present.
     *
     */
    Class<? extends OPENCONFIGALARMSEVERITY> getAlarmSeverity();
    
    /**
     * Return alarmSeverity, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The severity of the current alarm.
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends OPENCONFIGALARMSEVERITY>} alarmSeverity, guaranteed to be non-null.
     * @throws NoSuchElementException if alarmSeverity is not present
     *
     */
    default @NonNull Class<? extends OPENCONFIGALARMSEVERITY> requireAlarmSeverity() {
        return CodeHelpers.require(getAlarmSeverity(), "alarmseverity");
    }

}

