package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Operational state data for component properties
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * grouping platform-component-properties-state {
 *   leaf configurable {
 *     type boolean;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface PlatformComponentPropertiesState
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("platform-component-properties-state");

    @Override
    Class<? extends PlatformComponentPropertiesState> implementedInterface();
    
    /**
     * Return configurable, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Indication whether the property is user-configurable
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} configurable, or {@code null} if it is not present.
     *
     */
    Boolean getConfigurable();
    
    /**
     * Return configurable, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Indication whether the property is user-configurable
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} configurable, guaranteed to be non-null.
     * @throws NoSuchElementException if configurable is not present
     *
     */
    default @NonNull Boolean requireConfigurable() {
        return CodeHelpers.require(getConfigurable(), "configurable");
    }

}

