package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630;
import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint8;

@Generated("mdsal-binding-generator")
public class AuxiliaryId
 implements ScalarTypeObject<Uint8>, Serializable {
    private static final long serialVersionUID = -7703843254594446856L;
    private final Uint8 _value;

    private static void check_valueRange(final short value) {
        if (value <= (short)15) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..15]]", value);
    }

    @ConstructorParameters("value")
    @ConstructorProperties("value")
    public AuxiliaryId(Uint8 _value) {
        if (_value != null) {
            check_valueRange(_value.shortValue());
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public AuxiliaryId(AuxiliaryId source) {
        this._value = source._value;
    }

    public static AuxiliaryId getDefaultInstance(final String defaultValue) {
        return new AuxiliaryId(Uint8.valueOf(defaultValue));
    }

    @Override
    public Uint8 getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AuxiliaryId)) {
            return false;
        }
        final AuxiliaryId other = (AuxiliaryId) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(AuxiliaryId.class);
        CodeHelpers.appendValue(helper, "_value", _value);
        return helper.toString();
    }
}

