package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.connection;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowConnectionsConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowConnectionsState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.AuxiliaryId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.Transport;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private IpAddress _address;
    private AuxiliaryId _auxId;
    private String _certificateId;
    private Boolean _connected;
    private PortNumber _port;
    private Uint8 _priority;
    private String _sourceInterface;
    private Transport _transport;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }
    
    
    
    public StateBuilder(OpenflowConnectionsConfig arg) {
        this._auxId = arg.getAuxId();
        this._priority = arg.getPriority();
        this._address = arg.getAddress();
        this._port = arg.getPort();
        this._transport = arg.getTransport();
        this._certificateId = arg.getCertificateId();
        this._sourceInterface = arg.getSourceInterface();
    }
    
    public StateBuilder(OpenflowConnectionsState arg) {
        this._connected = arg.getConnected();
    }

    public StateBuilder(State base) {
        Map<Class<? extends Augmentation<State>>, Augmentation<State>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._address = base.getAddress();
        this._auxId = base.getAuxId();
        this._certificateId = base.getCertificateId();
        this._connected = base.getConnected();
        this._port = base.getPort();
        this._priority = base.getPriority();
        this._sourceInterface = base.getSourceInterface();
        this._transport = base.getTransport();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>OpenflowConnectionsState</li>
     * <li>OpenflowConnectionsConfig</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenflowConnectionsState) {
            this._connected = ((OpenflowConnectionsState)arg).getConnected();
            isValidArg = true;
        }
        if (arg instanceof OpenflowConnectionsConfig) {
            this._auxId = ((OpenflowConnectionsConfig)arg).getAuxId();
            this._priority = ((OpenflowConnectionsConfig)arg).getPriority();
            this._address = ((OpenflowConnectionsConfig)arg).getAddress();
            this._port = ((OpenflowConnectionsConfig)arg).getPort();
            this._transport = ((OpenflowConnectionsConfig)arg).getTransport();
            this._certificateId = ((OpenflowConnectionsConfig)arg).getCertificateId();
            this._sourceInterface = ((OpenflowConnectionsConfig)arg).getSourceInterface();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[OpenflowConnectionsState, OpenflowConnectionsConfig]");
    }

    public IpAddress getAddress() {
        return _address;
    }
    
    public AuxiliaryId getAuxId() {
        return _auxId;
    }
    
    public String getCertificateId() {
        return _certificateId;
    }
    
    public Boolean getConnected() {
        return _connected;
    }
    
    public PortNumber getPort() {
        return _port;
    }
    
    public Uint8 getPriority() {
        return _priority;
    }
    
    public String getSourceInterface() {
        return _sourceInterface;
    }
    
    public Transport getTransport() {
        return _transport;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public StateBuilder setAddress(final IpAddress value) {
        this._address = value;
        return this;
    }
    
    public StateBuilder setAuxId(final AuxiliaryId value) {
        this._auxId = value;
        return this;
    }
    
    public StateBuilder setCertificateId(final String value) {
        this._certificateId = value;
        return this;
    }
    
    public StateBuilder setConnected(final Boolean value) {
        this._connected = value;
        return this;
    }
    
    public StateBuilder setPort(final PortNumber value) {
        this._port = value;
        return this;
    }
    
    public StateBuilder setPriority(final Uint8 value) {
        this._priority = value;
        return this;
    }
    
    public StateBuilder setSourceInterface(final String value) {
        this._sourceInterface = value;
        return this;
    }
    
    public StateBuilder setTransport(final Transport value) {
        this._transport = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class<? extends Augmentation<State>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final IpAddress _address;
        private final AuxiliaryId _auxId;
        private final String _certificateId;
        private final Boolean _connected;
        private final PortNumber _port;
        private final Uint8 _priority;
        private final String _sourceInterface;
        private final Transport _transport;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._address = base.getAddress();
            this._auxId = base.getAuxId();
            this._certificateId = base.getCertificateId();
            this._connected = base.getConnected();
            this._port = base.getPort();
            this._priority = base.getPriority();
            this._sourceInterface = base.getSourceInterface();
            this._transport = base.getTransport();
        }
    
        @Override
        public IpAddress getAddress() {
            return _address;
        }
        
        @Override
        public AuxiliaryId getAuxId() {
            return _auxId;
        }
        
        @Override
        public String getCertificateId() {
            return _certificateId;
        }
        
        @Override
        public Boolean getConnected() {
            return _connected;
        }
        
        @Override
        public PortNumber getPort() {
            return _port;
        }
        
        @Override
        public Uint8 getPriority() {
            return _priority;
        }
        
        @Override
        public String getSourceInterface() {
            return _sourceInterface;
        }
        
        @Override
        public Transport getTransport() {
            return _transport;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
