package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.Connections;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.connection.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.connection.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.AuxiliaryId;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * List of connections to the OpenFlow controller. The Openflow switch always 
 * connects to configured Openflow controllers. Each controller can have more than 
 * one connection, called auxiliary Openflow connections.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-openflow</b>
 * <pre>
 * list connection {
 *   key aux-id;
 *   leaf aux-id {
 *     type leafref {
 *       path ../config/aux-id;
 *     }
 *   }
 *   container config {
 *     uses openflow-connections-config;
 *   }
 *   container state {
 *     config false;
 *     uses openflow-connections-config;
 *     uses openflow-connections-state;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ConnectionBuilder}.
 * @see ConnectionBuilder
 * @see ConnectionKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Connection
    extends
    ChildOf<Connections>,
    Augmentable<Connection>,
    Identifiable<ConnectionKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("connection");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.Connection> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.Connection.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.@NonNull Connection obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAuxId());
        result = prime * result + Objects.hashCode(obj.getConfig());
        result = prime * result + Objects.hashCode(obj.getState());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.@NonNull Connection thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.Connection other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.Connection.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAuxId(), other.getAuxId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getConfig(), other.getConfig())) {
            return false;
        }
        if (!Objects.equals(thisObj.getState(), other.getState())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.@NonNull Connection obj) {
        final var helper = MoreObjects.toStringHelper("Connection");
        CodeHelpers.appendValue(helper, "auxId", obj.getAuxId());
        CodeHelpers.appendValue(helper, "config", obj.getConfig());
        CodeHelpers.appendValue(helper, "state", obj.getState());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    ConnectionKey key();
    
    /**
     * Return auxId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reference to auxiliary id list key
     *     </code>
     * </pre>
     *
     * @return {@code AuxiliaryId} auxId, or {@code null} if it is not present.
     *
     */
    AuxiliaryId getAuxId();
    
    /**
     * Return auxId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Reference to auxiliary id list key
     *     </code>
     * </pre>
     *
     * @return {@code AuxiliaryId} auxId, guaranteed to be non-null.
     * @throws NoSuchElementException if auxId is not present
     *
     */
    default @NonNull AuxiliaryId requireAuxId() {
        return CodeHelpers.require(getAuxId(), "auxid");
    }
    
    /**
     * Return config, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Configuration data for OpenFlow controller connections
     *     </code>
     * </pre>
     *
     * @return {@code Config} config, or {@code null} if it is not present.
     *
     */
    Config getConfig();
    
    /**
     * Return state, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Operational state data for OpenFlow controller connections
     *     </code>
     * </pre>
     *
     * @return {@code State} state, or {@code null} if it is not present.
     *
     */
    State getState();

}

