package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.AuxiliaryId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.Transport;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Configuration data for OpenFlow controller connections
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-openflow</b>
 * <pre>
 * grouping openflow-connections-config {
 *   leaf aux-id {
 *     type of-types:auxiliary-id;
 *   }
 *   leaf priority {
 *     type uint8;
 *   }
 *   leaf address {
 *     type oc-inet:ip-address;
 *   }
 *   leaf port {
 *     type oc-inet:port-number;
 *     default 6653;
 *   }
 *   leaf transport {
 *     type of-types:transport;
 *     default TCP;
 *   }
 *   leaf certificate-id {
 *     type string;
 *   }
 *   leaf source-interface {
 *     type oc-if:base-interface-ref;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenflowConnectionsConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("openflow-connections-config");

    @Override
    Class<? extends OpenflowConnectionsConfig> implementedInterface();
    
    /**
     * Return auxId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Controller auxiliary ID. Must be 0 for the main controller. One controller may
     *         have multiple auxiliary connections as specified by the Openflow protocol.
     *         Besides configuring the main controller, it is also possible to configure
     *         auxiliary connections. The main controller must have the aux-id set to zero. All
     *         others must have an aux-id different from 0.
     *     </code>
     * </pre>
     *
     * @return {@code AuxiliaryId} auxId, or {@code null} if it is not present.
     *
     */
    AuxiliaryId getAuxId();
    
    /**
     * Return auxId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Controller auxiliary ID. Must be 0 for the main controller. One controller may
     *         have multiple auxiliary connections as specified by the Openflow protocol.
     *         Besides configuring the main controller, it is also possible to configure
     *         auxiliary connections. The main controller must have the aux-id set to zero. All
     *         others must have an aux-id different from 0.
     *     </code>
     * </pre>
     *
     * @return {@code AuxiliaryId} auxId, guaranteed to be non-null.
     * @throws NoSuchElementException if auxId is not present
     *
     */
    default @NonNull AuxiliaryId requireAuxId() {
        return CodeHelpers.require(getAuxId(), "auxid");
    }
    
    /**
     * Return priority, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Optional value for servicing auxiliary connections with different priorities.
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} priority, or {@code null} if it is not present.
     *
     */
    Uint8 getPriority();
    
    /**
     * Return priority, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Optional value for servicing auxiliary connections with different priorities.
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} priority, guaranteed to be non-null.
     * @throws NoSuchElementException if priority is not present
     *
     */
    default @NonNull Uint8 requirePriority() {
        return CodeHelpers.require(getPriority(), "priority");
    }
    
    /**
     * Return address, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The IP address of the controller.
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} address, or {@code null} if it is not present.
     *
     */
    IpAddress getAddress();
    
    /**
     * Return address, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The IP address of the controller.
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} address, guaranteed to be non-null.
     * @throws NoSuchElementException if address is not present
     *
     */
    default @NonNull IpAddress requireAddress() {
        return CodeHelpers.require(getAddress(), "address");
    }
    
    /**
     * Return port, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Controller port to use.
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} port, or {@code null} if it is not present.
     *
     */
    PortNumber getPort();
    
    /**
     * Return port, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Controller port to use.
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} port, guaranteed to be non-null.
     * @throws NoSuchElementException if port is not present
     *
     */
    default @NonNull PortNumber requirePort() {
        return CodeHelpers.require(getPort(), "port");
    }
    
    /**
     * Return transport, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Controller transport protocol used.
     *     </code>
     * </pre>
     *
     * @return {@code Transport} transport, or {@code null} if it is not present.
     *
     */
    Transport getTransport();
    
    /**
     * Return transport, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Controller transport protocol used.
     *     </code>
     * </pre>
     *
     * @return {@code Transport} transport, guaranteed to be non-null.
     * @throws NoSuchElementException if transport is not present
     *
     */
    default @NonNull Transport requireTransport() {
        return CodeHelpers.require(getTransport(), "transport");
    }
    
    /**
     * Return certificateId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Certificate ID is used for TLS connections. When installed, certificates are
     *         associated with an ID. This ID specifies the certificate to use in a TLS
     *         connection.
     *     </code>
     * </pre>
     *
     * @return {@code String} certificateId, or {@code null} if it is not present.
     *
     */
    String getCertificateId();
    
    /**
     * Return certificateId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Certificate ID is used for TLS connections. When installed, certificates are
     *         associated with an ID. This ID specifies the certificate to use in a TLS
     *         connection.
     *     </code>
     * </pre>
     *
     * @return {@code String} certificateId, guaranteed to be non-null.
     * @throws NoSuchElementException if certificateId is not present
     *
     */
    default @NonNull String requireCertificateId() {
        return CodeHelpers.require(getCertificateId(), "certificateid");
    }
    
    /**
     * Return sourceInterface, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Optionally specify the source interface for the controller connection.
     *     </code>
     * </pre>
     *
     * @return {@code String} sourceInterface, or {@code null} if it is not present.
     *
     */
    String getSourceInterface();
    
    /**
     * Return sourceInterface, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Optionally specify the source interface for the controller connection.
     *     </code>
     * </pre>
     *
     * @return {@code String} sourceInterface, guaranteed to be non-null.
     * @throws NoSuchElementException if sourceInterface is not present
     *
     */
    default @NonNull String requireSourceInterface() {
        return CodeHelpers.require(getSourceInterface(), "sourceinterface");
    }

}

