package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.DatapathId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.FailureMode;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Openflow agent config
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-openflow</b>
 * <pre>
 * grouping openflow-agent-config {
 *   leaf datapath-id {
 *     type of-types:datapath-id;
 *   }
 *   leaf failure-mode {
 *     type of-types:failure-mode;
 *   }
 *   leaf backoff-interval {
 *     type uint32;
 *     units seconds;
 *   }
 *   leaf max-backoff {
 *     type uint32;
 *     units seconds;
 *   }
 *   leaf inactivity-probe {
 *     type uint32;
 *     units seconds;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenflowAgentConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("openflow-agent-config");

    @Override
    Class<? extends OpenflowAgentConfig> implementedInterface();
    
    /**
     * Return datapathId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Datapath unique ID. The lower 48-bits are for a MAC address, while the upper
     *         16-bits are implementer-defined.
     *     </code>
     * </pre>
     *
     * @return {@code DatapathId} datapathId, or {@code null} if it is not present.
     *
     */
    DatapathId getDatapathId();
    
    /**
     * Return datapathId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Datapath unique ID. The lower 48-bits are for a MAC address, while the upper
     *         16-bits are implementer-defined.
     *     </code>
     * </pre>
     *
     * @return {@code DatapathId} datapathId, guaranteed to be non-null.
     * @throws NoSuchElementException if datapathId is not present
     *
     */
    default @NonNull DatapathId requireDatapathId() {
        return CodeHelpers.require(getDatapathId(), "datapathid");
    }
    
    /**
     * Return failureMode, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Failure mode for Openflow.
     *     </code>
     * </pre>
     *
     * @return {@code FailureMode} failureMode, or {@code null} if it is not present.
     *
     */
    FailureMode getFailureMode();
    
    /**
     * Return failureMode, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Failure mode for Openflow.
     *     </code>
     * </pre>
     *
     * @return {@code FailureMode} failureMode, guaranteed to be non-null.
     * @throws NoSuchElementException if failureMode is not present
     *
     */
    default @NonNull FailureMode requireFailureMode() {
        return CodeHelpers.require(getFailureMode(), "failuremode");
    }
    
    /**
     * Return backoffInterval, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Openflow agent connection backoff interval.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} backoffInterval, or {@code null} if it is not present.
     *
     */
    Uint32 getBackoffInterval();
    
    /**
     * Return backoffInterval, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Openflow agent connection backoff interval.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} backoffInterval, guaranteed to be non-null.
     * @throws NoSuchElementException if backoffInterval is not present
     *
     */
    default @NonNull Uint32 requireBackoffInterval() {
        return CodeHelpers.require(getBackoffInterval(), "backoffinterval");
    }
    
    /**
     * Return maxBackoff, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Openflow agent max backoff time.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} maxBackoff, or {@code null} if it is not present.
     *
     */
    Uint32 getMaxBackoff();
    
    /**
     * Return maxBackoff, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Openflow agent max backoff time.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} maxBackoff, guaranteed to be non-null.
     * @throws NoSuchElementException if maxBackoff is not present
     *
     */
    default @NonNull Uint32 requireMaxBackoff() {
        return CodeHelpers.require(getMaxBackoff(), "maxbackoff");
    }
    
    /**
     * Return inactivityProbe, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Openflow agent inactivity probe period.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} inactivityProbe, or {@code null} if it is not present.
     *
     */
    Uint32 getInactivityProbe();
    
    /**
     * Return inactivityProbe, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Openflow agent inactivity probe period.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} inactivityProbe, guaranteed to be non-null.
     * @throws NoSuchElementException if inactivityProbe is not present
     *
     */
    default @NonNull Uint32 requireInactivityProbe() {
        return CodeHelpers.require(getInactivityProbe(), "inactivityprobe");
    }

}

