package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.SyslogSeverity;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for defining Syslog message severity.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-messages</b>
 * <pre>
 * grouping messages-config {
 *   leaf severity {
 *     type oc-log:syslog-severity;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface MessagesConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("messages-config");

    @Override
    Class<? extends MessagesConfig> implementedInterface();
    
    /**
     * Return severity, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Specifies that only messages of the given severity (or greater severity) are
     *         sent over the RPC. This is analogous to differentiating which severity is to be
     *         sent to legacy Syslog servers, as opposed to local buffer or files.
     *     </code>
     * </pre>
     *
     * @return {@code SyslogSeverity} severity, or {@code null} if it is not present.
     *
     */
    SyslogSeverity getSeverity();
    
    /**
     * Return severity, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Specifies that only messages of the given severity (or greater severity) are
     *         sent over the RPC. This is analogous to differentiating which severity is to be
     *         sent to legacy Syslog servers, as opposed to local buffer or files.
     *     </code>
     * </pre>
     *
     * @return {@code SyslogSeverity} severity, guaranteed to be non-null.
     * @throws NoSuchElementException if severity is not present
     *
     */
    default @NonNull SyslogSeverity requireSeverity() {
        return CodeHelpers.require(getSeverity(), "severity");
    }

}

