package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.LicensesTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.License;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.LicenseKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container for list of licenses
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-license</b>
 * <pre>
 * container licenses {
 *   list license {
 *     key license-id;
 *     leaf license-id {
 *       type leafref {
 *         path ../config/license-id;
 *       }
 *     }
 *     container config {
 *       uses license-config;
 *     }
 *     container state {
 *       config false;
 *       uses license-config;
 *       uses license-state;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link LicensesBuilder}.
 * @see LicensesBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Licenses
    extends
    ChildOf<LicensesTop>,
    Augmentable<Licenses>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("licenses");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.Licenses> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.Licenses.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.@NonNull Licenses obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getLicense());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.@NonNull Licenses thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.Licenses other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.Licenses.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getLicense(), other.getLicense())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.@NonNull Licenses obj) {
        final var helper = MoreObjects.toStringHelper("Licenses");
        CodeHelpers.appendValue(helper, "license", obj.getLicense());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return license, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of licenses.
     *     </code>
     * </pre>
     *
     * @return {@code Map<LicenseKey, License>} license, or {@code null} if it is not present.
     *
     */
    @Nullable Map<LicenseKey, License> getLicense();
    
    /**
     * Return license, or an empty list if it is not present.
     *
     * @return {@code Map<LicenseKey, License>} license, or an empty list if it is not present.
     *
     */
    default @NonNull Map<LicenseKey, License> nonnullLicense() {
        return CodeHelpers.nonnull(getLicense());
    }

}

