package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * State data for license
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-license</b>
 * <pre>
 * grouping license-state {
 *   leaf description {
 *     type string;
 *   }
 *   leaf issue-date {
 *     type uint64;
 *   }
 *   leaf expiration-date {
 *     type uint64;
 *   }
 *   leaf in-use {
 *     type boolean;
 *   }
 *   leaf expired {
 *     type boolean;
 *   }
 *   leaf valid {
 *     type boolean;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface LicenseState
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("license-state");

    @Override
    Class<? extends LicenseState> implementedInterface();
    
    /**
     * Return description, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The license description.
     *     </code>
     * </pre>
     *
     * @return {@code String} description, or {@code null} if it is not present.
     *
     */
    String getDescription();
    
    /**
     * Return description, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The license description.
     *     </code>
     * </pre>
     *
     * @return {@code String} description, guaranteed to be non-null.
     * @throws NoSuchElementException if description is not present
     *
     */
    default @NonNull String requireDescription() {
        return CodeHelpers.require(getDescription(), "description");
    }
    
    /**
     * Return issueDate, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The date and time at which the license was issued, expressed as the number of
     *         nanoseconds since the Unix Epoch (January 1, 1970, 00:00 UTC).
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} issueDate, or {@code null} if it is not present.
     *
     */
    Uint64 getIssueDate();
    
    /**
     * Return issueDate, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The date and time at which the license was issued, expressed as the number of
     *         nanoseconds since the Unix Epoch (January 1, 1970, 00:00 UTC).
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} issueDate, guaranteed to be non-null.
     * @throws NoSuchElementException if issueDate is not present
     *
     */
    default @NonNull Uint64 requireIssueDate() {
        return CodeHelpers.require(getIssueDate(), "issuedate");
    }
    
    /**
     * Return expirationDate, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The date and time at which the license will expire, expressed as the number of
     *         nanoseconds since the Unix Epoch (January 1, 1970, 00:00 UTC). Zero if it does
     *         not expire.
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} expirationDate, or {@code null} if it is not present.
     *
     */
    Uint64 getExpirationDate();
    
    /**
     * Return expirationDate, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The date and time at which the license will expire, expressed as the number of
     *         nanoseconds since the Unix Epoch (January 1, 1970, 00:00 UTC). Zero if it does
     *         not expire.
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} expirationDate, guaranteed to be non-null.
     * @throws NoSuchElementException if expirationDate is not present
     *
     */
    default @NonNull Uint64 requireExpirationDate() {
        return CodeHelpers.require(getExpirationDate(), "expirationdate");
    }
    
    /**
     * Return inUse, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The license is in use. Different from active. This states that the license is
     *         effectively being used in addition to being active. If license for feature X was
     *         activated but feature X is not being used, then this should be false.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} inUse, or {@code null} if it is not present.
     *
     */
    Boolean getInUse();
    
    /**
     * Return inUse, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The license is in use. Different from active. This states that the license is
     *         effectively being used in addition to being active. If license for feature X was
     *         activated but feature X is not being used, then this should be false.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} inUse, guaranteed to be non-null.
     * @throws NoSuchElementException if inUse is not present
     *
     */
    default @NonNull Boolean requireInUse() {
        return CodeHelpers.require(getInUse(), "inuse");
    }
    
    /**
     * Return expired, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The license has expired.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} expired, or {@code null} if it is not present.
     *
     */
    Boolean getExpired();
    
    /**
     * Return expired, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The license has expired.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} expired, guaranteed to be non-null.
     * @throws NoSuchElementException if expired is not present
     *
     */
    default @NonNull Boolean requireExpired() {
        return CodeHelpers.require(getExpired(), "expired");
    }
    
    /**
     * Return valid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The license is valid. Can be activated in the system or platform.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} valid, or {@code null} if it is not present.
     *
     */
    Boolean getValid();
    
    /**
     * Return valid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The license is valid. Can be activated in the system or platform.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} valid, guaranteed to be non-null.
     * @throws NoSuchElementException if valid is not present
     *
     */
    default @NonNull Boolean requireValid() {
        return CodeHelpers.require(getValid(), "valid");
    }

}

