package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ETHERNETSPEED;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig.DuplexMode;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceState.NegotiatedDuplexMode;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.Counters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.MacAddress;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private Boolean _autoNegotiate;
    private Counters _counters;
    private DuplexMode _duplexMode;
    private Boolean _enableFlowControl;
    private MacAddress _hwMacAddress;
    private MacAddress _macAddress;
    private NegotiatedDuplexMode _negotiatedDuplexMode;
    private Class<? extends ETHERNETSPEED> _negotiatedPortSpeed;
    private Class<? extends ETHERNETSPEED> _portSpeed;
    private Boolean _standaloneLinkTraining;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }
    
    
    
    public StateBuilder(EthernetInterfaceConfig arg) {
        this._macAddress = arg.getMacAddress();
        this._autoNegotiate = arg.getAutoNegotiate();
        this._standaloneLinkTraining = arg.getStandaloneLinkTraining();
        this._duplexMode = arg.getDuplexMode();
        this._portSpeed = arg.getPortSpeed();
        this._enableFlowControl = arg.getEnableFlowControl();
    }
    
    public StateBuilder(EthernetInterfaceState arg) {
        this._hwMacAddress = arg.getHwMacAddress();
        this._negotiatedDuplexMode = arg.getNegotiatedDuplexMode();
        this._negotiatedPortSpeed = arg.getNegotiatedPortSpeed();
        this._counters = arg.getCounters();
    }

    public StateBuilder(State base) {
        Map<Class<? extends Augmentation<State>>, Augmentation<State>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._autoNegotiate = base.getAutoNegotiate();
        this._counters = base.getCounters();
        this._duplexMode = base.getDuplexMode();
        this._enableFlowControl = base.getEnableFlowControl();
        this._hwMacAddress = base.getHwMacAddress();
        this._macAddress = base.getMacAddress();
        this._negotiatedDuplexMode = base.getNegotiatedDuplexMode();
        this._negotiatedPortSpeed = base.getNegotiatedPortSpeed();
        this._portSpeed = base.getPortSpeed();
        this._standaloneLinkTraining = base.getStandaloneLinkTraining();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>EthernetInterfaceConfig</li>
     * <li>EthernetInterfaceState</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EthernetInterfaceConfig) {
            this._macAddress = ((EthernetInterfaceConfig)arg).getMacAddress();
            this._autoNegotiate = ((EthernetInterfaceConfig)arg).getAutoNegotiate();
            this._standaloneLinkTraining = ((EthernetInterfaceConfig)arg).getStandaloneLinkTraining();
            this._duplexMode = ((EthernetInterfaceConfig)arg).getDuplexMode();
            this._portSpeed = ((EthernetInterfaceConfig)arg).getPortSpeed();
            this._enableFlowControl = ((EthernetInterfaceConfig)arg).getEnableFlowControl();
            isValidArg = true;
        }
        if (arg instanceof EthernetInterfaceState) {
            this._hwMacAddress = ((EthernetInterfaceState)arg).getHwMacAddress();
            this._negotiatedDuplexMode = ((EthernetInterfaceState)arg).getNegotiatedDuplexMode();
            this._negotiatedPortSpeed = ((EthernetInterfaceState)arg).getNegotiatedPortSpeed();
            this._counters = ((EthernetInterfaceState)arg).getCounters();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[EthernetInterfaceConfig, EthernetInterfaceState]");
    }

    public Boolean getAutoNegotiate() {
        return _autoNegotiate;
    }
    
    public Counters getCounters() {
        return _counters;
    }
    
    public DuplexMode getDuplexMode() {
        return _duplexMode;
    }
    
    public Boolean getEnableFlowControl() {
        return _enableFlowControl;
    }
    
    public MacAddress getHwMacAddress() {
        return _hwMacAddress;
    }
    
    public MacAddress getMacAddress() {
        return _macAddress;
    }
    
    public NegotiatedDuplexMode getNegotiatedDuplexMode() {
        return _negotiatedDuplexMode;
    }
    
    public Class<? extends ETHERNETSPEED> getNegotiatedPortSpeed() {
        return _negotiatedPortSpeed;
    }
    
    public Class<? extends ETHERNETSPEED> getPortSpeed() {
        return _portSpeed;
    }
    
    public Boolean getStandaloneLinkTraining() {
        return _standaloneLinkTraining;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public StateBuilder setAutoNegotiate(final Boolean value) {
        this._autoNegotiate = value;
        return this;
    }
    
    public StateBuilder setCounters(final Counters value) {
        this._counters = value;
        return this;
    }
    
    public StateBuilder setDuplexMode(final DuplexMode value) {
        this._duplexMode = value;
        return this;
    }
    
    public StateBuilder setEnableFlowControl(final Boolean value) {
        this._enableFlowControl = value;
        return this;
    }
    
    public StateBuilder setHwMacAddress(final MacAddress value) {
        this._hwMacAddress = value;
        return this;
    }
    
    public StateBuilder setMacAddress(final MacAddress value) {
        this._macAddress = value;
        return this;
    }
    
    public StateBuilder setNegotiatedDuplexMode(final NegotiatedDuplexMode value) {
        this._negotiatedDuplexMode = value;
        return this;
    }
    
    public StateBuilder setNegotiatedPortSpeed(final Class<? extends ETHERNETSPEED> value) {
        this._negotiatedPortSpeed = value;
        return this;
    }
    
    public StateBuilder setPortSpeed(final Class<? extends ETHERNETSPEED> value) {
        this._portSpeed = value;
        return this;
    }
    
    public StateBuilder setStandaloneLinkTraining(final Boolean value) {
        this._standaloneLinkTraining = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class<? extends Augmentation<State>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final Boolean _autoNegotiate;
        private final Counters _counters;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig.DuplexMode _duplexMode;
        private final Boolean _enableFlowControl;
        private final MacAddress _hwMacAddress;
        private final MacAddress _macAddress;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceState.NegotiatedDuplexMode _negotiatedDuplexMode;
        private final Class<? extends ETHERNETSPEED> _negotiatedPortSpeed;
        private final Class<? extends ETHERNETSPEED> _portSpeed;
        private final Boolean _standaloneLinkTraining;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._autoNegotiate = base.getAutoNegotiate();
            this._counters = base.getCounters();
            this._duplexMode = base.getDuplexMode();
            this._enableFlowControl = base.getEnableFlowControl();
            this._hwMacAddress = base.getHwMacAddress();
            this._macAddress = base.getMacAddress();
            this._negotiatedDuplexMode = base.getNegotiatedDuplexMode();
            this._negotiatedPortSpeed = base.getNegotiatedPortSpeed();
            this._portSpeed = base.getPortSpeed();
            this._standaloneLinkTraining = base.getStandaloneLinkTraining();
        }
    
        @Override
        public Boolean getAutoNegotiate() {
            return _autoNegotiate;
        }
        
        @Override
        public Counters getCounters() {
            return _counters;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig.DuplexMode getDuplexMode() {
            return _duplexMode;
        }
        
        @Override
        public Boolean getEnableFlowControl() {
            return _enableFlowControl;
        }
        
        @Override
        public MacAddress getHwMacAddress() {
            return _hwMacAddress;
        }
        
        @Override
        public MacAddress getMacAddress() {
            return _macAddress;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceState.NegotiatedDuplexMode getNegotiatedDuplexMode() {
            return _negotiatedDuplexMode;
        }
        
        @Override
        public Class<? extends ETHERNETSPEED> getNegotiatedPortSpeed() {
            return _negotiatedPortSpeed;
        }
        
        @Override
        public Class<? extends ETHERNETSPEED> getPortSpeed() {
            return _portSpeed;
        }
        
        @Override
        public Boolean getStandaloneLinkTraining() {
            return _standaloneLinkTraining;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
