package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceStateCounters;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Ethernet interface counters
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-ethernet</b>
 * <pre>
 * container counters {
 *   uses ethernet-interface-state-counters;
 * }
 * </pre>
 * <p>To create instances of this class use {@link CountersBuilder}.
 * @see CountersBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Counters
    extends
    ChildOf<EthernetInterfaceState>,
    Augmentable<Counters>,
    EthernetInterfaceStateCounters
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("counters");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.Counters> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.Counters.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.@NonNull Counters obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getIn8021qFrames());
        result = prime * result + Objects.hashCode(obj.getInBlockErrors());
        result = prime * result + Objects.hashCode(obj.getInCarrierErrors());
        result = prime * result + Objects.hashCode(obj.getInCrcErrors());
        result = prime * result + Objects.hashCode(obj.getInFragmentFrames());
        result = prime * result + Objects.hashCode(obj.getInInterruptedTx());
        result = prime * result + Objects.hashCode(obj.getInJabberFrames());
        result = prime * result + Objects.hashCode(obj.getInLateCollision());
        result = prime * result + Objects.hashCode(obj.getInMacControlFrames());
        result = prime * result + Objects.hashCode(obj.getInMacErrorsRx());
        result = prime * result + Objects.hashCode(obj.getInMacPauseFrames());
        result = prime * result + Objects.hashCode(obj.getInMaxsizeExceeded());
        result = prime * result + Objects.hashCode(obj.getInOversizeFrames());
        result = prime * result + Objects.hashCode(obj.getInSingleCollision());
        result = prime * result + Objects.hashCode(obj.getInSymbolError());
        result = prime * result + Objects.hashCode(obj.getInUndersizeFrames());
        result = prime * result + Objects.hashCode(obj.getOut8021qFrames());
        result = prime * result + Objects.hashCode(obj.getOutMacControlFrames());
        result = prime * result + Objects.hashCode(obj.getOutMacErrorsTx());
        result = prime * result + Objects.hashCode(obj.getOutMacPauseFrames());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.@NonNull Counters thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.Counters other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.Counters.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getIn8021qFrames(), other.getIn8021qFrames())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInBlockErrors(), other.getInBlockErrors())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInCarrierErrors(), other.getInCarrierErrors())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInCrcErrors(), other.getInCrcErrors())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInFragmentFrames(), other.getInFragmentFrames())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInInterruptedTx(), other.getInInterruptedTx())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInJabberFrames(), other.getInJabberFrames())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInLateCollision(), other.getInLateCollision())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInMacControlFrames(), other.getInMacControlFrames())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInMacErrorsRx(), other.getInMacErrorsRx())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInMacPauseFrames(), other.getInMacPauseFrames())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInMaxsizeExceeded(), other.getInMaxsizeExceeded())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInOversizeFrames(), other.getInOversizeFrames())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInSingleCollision(), other.getInSingleCollision())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInSymbolError(), other.getInSymbolError())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInUndersizeFrames(), other.getInUndersizeFrames())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOut8021qFrames(), other.getOut8021qFrames())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOutMacControlFrames(), other.getOutMacControlFrames())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOutMacErrorsTx(), other.getOutMacErrorsTx())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOutMacPauseFrames(), other.getOutMacPauseFrames())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.@NonNull Counters obj) {
        final var helper = MoreObjects.toStringHelper("Counters");
        CodeHelpers.appendValue(helper, "in8021qFrames", obj.getIn8021qFrames());
        CodeHelpers.appendValue(helper, "inBlockErrors", obj.getInBlockErrors());
        CodeHelpers.appendValue(helper, "inCarrierErrors", obj.getInCarrierErrors());
        CodeHelpers.appendValue(helper, "inCrcErrors", obj.getInCrcErrors());
        CodeHelpers.appendValue(helper, "inFragmentFrames", obj.getInFragmentFrames());
        CodeHelpers.appendValue(helper, "inInterruptedTx", obj.getInInterruptedTx());
        CodeHelpers.appendValue(helper, "inJabberFrames", obj.getInJabberFrames());
        CodeHelpers.appendValue(helper, "inLateCollision", obj.getInLateCollision());
        CodeHelpers.appendValue(helper, "inMacControlFrames", obj.getInMacControlFrames());
        CodeHelpers.appendValue(helper, "inMacErrorsRx", obj.getInMacErrorsRx());
        CodeHelpers.appendValue(helper, "inMacPauseFrames", obj.getInMacPauseFrames());
        CodeHelpers.appendValue(helper, "inMaxsizeExceeded", obj.getInMaxsizeExceeded());
        CodeHelpers.appendValue(helper, "inOversizeFrames", obj.getInOversizeFrames());
        CodeHelpers.appendValue(helper, "inSingleCollision", obj.getInSingleCollision());
        CodeHelpers.appendValue(helper, "inSymbolError", obj.getInSymbolError());
        CodeHelpers.appendValue(helper, "inUndersizeFrames", obj.getInUndersizeFrames());
        CodeHelpers.appendValue(helper, "out8021qFrames", obj.getOut8021qFrames());
        CodeHelpers.appendValue(helper, "outMacControlFrames", obj.getOutMacControlFrames());
        CodeHelpers.appendValue(helper, "outMacErrorsTx", obj.getOutMacErrorsTx());
        CodeHelpers.appendValue(helper, "outMacPauseFrames", obj.getOutMacPauseFrames());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

