package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Counter64;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Ethernet-specific counters and statistics
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-ethernet</b>
 * <pre>
 * grouping ethernet-interface-state-counters {
 *   leaf in-mac-control-frames {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-mac-pause-frames {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-oversize-frames {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-undersize-frames {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-jabber-frames {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-fragment-frames {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-8021q-frames {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-crc-errors {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-block-errors {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-carrier-errors {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-interrupted-tx {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-late-collision {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-mac-errors-rx {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-single-collision {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-symbol-error {
 *     type oc-yang:counter64;
 *   }
 *   leaf in-maxsize-exceeded {
 *     type oc-yang:counter64;
 *   }
 *   leaf out-mac-control-frames {
 *     type oc-yang:counter64;
 *   }
 *   leaf out-mac-pause-frames {
 *     type oc-yang:counter64;
 *   }
 *   leaf out-8021q-frames {
 *     type oc-yang:counter64;
 *   }
 *   leaf out-mac-errors-tx {
 *     type oc-yang:counter64;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface EthernetInterfaceStateCounters
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ethernet-interface-state-counters");

    @Override
    Class<? extends EthernetInterfaceStateCounters> implementedInterface();
    
    /**
     * Return inMacControlFrames, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         MAC layer control frames received on the interface
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inMacControlFrames, or {@code null} if it is not present.
     *
     */
    Counter64 getInMacControlFrames();
    
    /**
     * Return inMacControlFrames, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         MAC layer control frames received on the interface
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inMacControlFrames, guaranteed to be non-null.
     * @throws NoSuchElementException if inMacControlFrames is not present
     *
     */
    default @NonNull Counter64 requireInMacControlFrames() {
        return CodeHelpers.require(getInMacControlFrames(), "inmaccontrolframes");
    }
    
    /**
     * Return inMacPauseFrames, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         MAC layer PAUSE frames received on the interface
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inMacPauseFrames, or {@code null} if it is not present.
     *
     */
    Counter64 getInMacPauseFrames();
    
    /**
     * Return inMacPauseFrames, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         MAC layer PAUSE frames received on the interface
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inMacPauseFrames, guaranteed to be non-null.
     * @throws NoSuchElementException if inMacPauseFrames is not present
     *
     */
    default @NonNull Counter64 requireInMacPauseFrames() {
        return CodeHelpers.require(getInMacPauseFrames(), "inmacpauseframes");
    }
    
    /**
     * Return inOversizeFrames, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The total number of frames received that were longer than 1518 octets (excluding
     *         framing bits, but including FCS octets) and were otherwise well formed.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inOversizeFrames, or {@code null} if it is not present.
     *
     */
    Counter64 getInOversizeFrames();
    
    /**
     * Return inOversizeFrames, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The total number of frames received that were longer than 1518 octets (excluding
     *         framing bits, but including FCS octets) and were otherwise well formed.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inOversizeFrames, guaranteed to be non-null.
     * @throws NoSuchElementException if inOversizeFrames is not present
     *
     */
    default @NonNull Counter64 requireInOversizeFrames() {
        return CodeHelpers.require(getInOversizeFrames(), "inoversizeframes");
    }
    
    /**
     * Return inUndersizeFrames, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The total number of frames received that were less than 64 octets long
     *         (excluding framing bits, but including FCS octets) and were otherwise well
     *         formed.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inUndersizeFrames, or {@code null} if it is not present.
     *
     */
    Counter64 getInUndersizeFrames();
    
    /**
     * Return inUndersizeFrames, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The total number of frames received that were less than 64 octets long
     *         (excluding framing bits, but including FCS octets) and were otherwise well
     *         formed.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inUndersizeFrames, guaranteed to be non-null.
     * @throws NoSuchElementException if inUndersizeFrames is not present
     *
     */
    default @NonNull Counter64 requireInUndersizeFrames() {
        return CodeHelpers.require(getInUndersizeFrames(), "inundersizeframes");
    }
    
    /**
     * Return inJabberFrames, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of jabber frames received on the interface. Jabber frames are typically
     *         defined as oversize frames which also have a bad CRC. Implementations may use
     *         slightly different definitions of what constitutes a jabber frame. Often
     *         indicative of a NIC hardware problem.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inJabberFrames, or {@code null} if it is not present.
     *
     */
    Counter64 getInJabberFrames();
    
    /**
     * Return inJabberFrames, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of jabber frames received on the interface. Jabber frames are typically
     *         defined as oversize frames which also have a bad CRC. Implementations may use
     *         slightly different definitions of what constitutes a jabber frame. Often
     *         indicative of a NIC hardware problem.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inJabberFrames, guaranteed to be non-null.
     * @throws NoSuchElementException if inJabberFrames is not present
     *
     */
    default @NonNull Counter64 requireInJabberFrames() {
        return CodeHelpers.require(getInJabberFrames(), "injabberframes");
    }
    
    /**
     * Return inFragmentFrames, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The total number of frames received that were less than 64 octets in length
     *         (excluding framing bits but including FCS octets) and had either a bad Frame
     *         Check Sequence (FCS) with an integral number of octets (FCS Error) or a bad FCS
     *         with a non-integral number of octets (Alignment Error).
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inFragmentFrames, or {@code null} if it is not present.
     *
     */
    Counter64 getInFragmentFrames();
    
    /**
     * Return inFragmentFrames, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The total number of frames received that were less than 64 octets in length
     *         (excluding framing bits but including FCS octets) and had either a bad Frame
     *         Check Sequence (FCS) with an integral number of octets (FCS Error) or a bad FCS
     *         with a non-integral number of octets (Alignment Error).
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inFragmentFrames, guaranteed to be non-null.
     * @throws NoSuchElementException if inFragmentFrames is not present
     *
     */
    default @NonNull Counter64 requireInFragmentFrames() {
        return CodeHelpers.require(getInFragmentFrames(), "infragmentframes");
    }
    
    /**
     * Return in8021qFrames, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of 802.1q tagged frames received on the interface
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} in8021qFrames, or {@code null} if it is not present.
     *
     */
    Counter64 getIn8021qFrames();
    
    /**
     * Return in8021qFrames, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of 802.1q tagged frames received on the interface
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} in8021qFrames, guaranteed to be non-null.
     * @throws NoSuchElementException if in8021qFrames is not present
     *
     */
    default @NonNull Counter64 requireIn8021qFrames() {
        return CodeHelpers.require(getIn8021qFrames(), "in8021qframes");
    }
    
    /**
     * Return inCrcErrors, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The total number of frames received that had a length (excluding framing bits,
     *         but including FCS octets) of between 64 and 1518 octets, inclusive, but had
     *         either a bad Frame Check Sequence (FCS) with an integral number of octets (FCS
     *         Error) or a bad FCS with a non-integral number of octets (Alignment Error)
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inCrcErrors, or {@code null} if it is not present.
     *
     */
    Counter64 getInCrcErrors();
    
    /**
     * Return inCrcErrors, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The total number of frames received that had a length (excluding framing bits,
     *         but including FCS octets) of between 64 and 1518 octets, inclusive, but had
     *         either a bad Frame Check Sequence (FCS) with an integral number of octets (FCS
     *         Error) or a bad FCS with a non-integral number of octets (Alignment Error)
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inCrcErrors, guaranteed to be non-null.
     * @throws NoSuchElementException if inCrcErrors is not present
     *
     */
    default @NonNull Counter64 requireInCrcErrors() {
        return CodeHelpers.require(getInCrcErrors(), "incrcerrors");
    }
    
    /**
     * Return inBlockErrors, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The number of received errored blocks. Error detection codes are capable of
     *         detecting whether one or more errors have occurred in a given sequence of bits –
     *         the block. It is normally not possible to determine the exact number of errored
     *         bits within the block
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inBlockErrors, or {@code null} if it is not present.
     *
     */
    Counter64 getInBlockErrors();
    
    /**
     * Return inBlockErrors, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The number of received errored blocks. Error detection codes are capable of
     *         detecting whether one or more errors have occurred in a given sequence of bits –
     *         the block. It is normally not possible to determine the exact number of errored
     *         bits within the block
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inBlockErrors, guaranteed to be non-null.
     * @throws NoSuchElementException if inBlockErrors is not present
     *
     */
    default @NonNull Counter64 requireInBlockErrors() {
        return CodeHelpers.require(getInBlockErrors(), "inblockerrors");
    }
    
    /**
     * Return inCarrierErrors, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The number of received errored frames due to a carrier issue. The value refers
     *         to MIB counter for dot3StatsCarrierSenseErrors oid=1.3.6.1.2.1.10.7.2.1.11
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inCarrierErrors, or {@code null} if it is not present.
     *
     */
    Counter64 getInCarrierErrors();
    
    /**
     * Return inCarrierErrors, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The number of received errored frames due to a carrier issue. The value refers
     *         to MIB counter for dot3StatsCarrierSenseErrors oid=1.3.6.1.2.1.10.7.2.1.11
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inCarrierErrors, guaranteed to be non-null.
     * @throws NoSuchElementException if inCarrierErrors is not present
     *
     */
    default @NonNull Counter64 requireInCarrierErrors() {
        return CodeHelpers.require(getInCarrierErrors(), "incarriererrors");
    }
    
    /**
     * Return inInterruptedTx, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The number of received errored frames due to interrupted transmission issue. The
     *         value refers to MIB counter for dot3StatsDeferredTransmissions
     *         oid=1.3.6.1.2.1.10.7.2.1.7
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inInterruptedTx, or {@code null} if it is not present.
     *
     */
    Counter64 getInInterruptedTx();
    
    /**
     * Return inInterruptedTx, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The number of received errored frames due to interrupted transmission issue. The
     *         value refers to MIB counter for dot3StatsDeferredTransmissions
     *         oid=1.3.6.1.2.1.10.7.2.1.7
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inInterruptedTx, guaranteed to be non-null.
     * @throws NoSuchElementException if inInterruptedTx is not present
     *
     */
    default @NonNull Counter64 requireInInterruptedTx() {
        return CodeHelpers.require(getInInterruptedTx(), "ininterruptedtx");
    }
    
    /**
     * Return inLateCollision, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The number of received errored frames due to late collision issue. The value
     *         refers to MIB counter for dot3StatsLateCollisions oid=1.3.6.1.2.1.10.7.2.1.8
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inLateCollision, or {@code null} if it is not present.
     *
     */
    Counter64 getInLateCollision();
    
    /**
     * Return inLateCollision, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The number of received errored frames due to late collision issue. The value
     *         refers to MIB counter for dot3StatsLateCollisions oid=1.3.6.1.2.1.10.7.2.1.8
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inLateCollision, guaranteed to be non-null.
     * @throws NoSuchElementException if inLateCollision is not present
     *
     */
    default @NonNull Counter64 requireInLateCollision() {
        return CodeHelpers.require(getInLateCollision(), "inlatecollision");
    }
    
    /**
     * Return inMacErrorsRx, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The number of received errored frames due to MAC errors received. The value
     *         refers to MIB counter for dot3StatsInternalMacReceiveErrors
     *         oid=1.3.6.1.2.1.10.7.2.1.16
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inMacErrorsRx, or {@code null} if it is not present.
     *
     */
    Counter64 getInMacErrorsRx();
    
    /**
     * Return inMacErrorsRx, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The number of received errored frames due to MAC errors received. The value
     *         refers to MIB counter for dot3StatsInternalMacReceiveErrors
     *         oid=1.3.6.1.2.1.10.7.2.1.16
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inMacErrorsRx, guaranteed to be non-null.
     * @throws NoSuchElementException if inMacErrorsRx is not present
     *
     */
    default @NonNull Counter64 requireInMacErrorsRx() {
        return CodeHelpers.require(getInMacErrorsRx(), "inmacerrorsrx");
    }
    
    /**
     * Return inSingleCollision, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The number of received errored frames due to single collision issue. The value
     *         refers to MIB counter for dot3StatsSingleCollisionFrames
     *         oid=1.3.6.1.2.1.10.7.2.1.4
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inSingleCollision, or {@code null} if it is not present.
     *
     */
    Counter64 getInSingleCollision();
    
    /**
     * Return inSingleCollision, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The number of received errored frames due to single collision issue. The value
     *         refers to MIB counter for dot3StatsSingleCollisionFrames
     *         oid=1.3.6.1.2.1.10.7.2.1.4
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inSingleCollision, guaranteed to be non-null.
     * @throws NoSuchElementException if inSingleCollision is not present
     *
     */
    default @NonNull Counter64 requireInSingleCollision() {
        return CodeHelpers.require(getInSingleCollision(), "insinglecollision");
    }
    
    /**
     * Return inSymbolError, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The number of received errored frames due to symbol error. The value refers to
     *         MIB counter for in-symbol-error oid=1.3.6.1.2.1.10.7.2.1.18
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inSymbolError, or {@code null} if it is not present.
     *
     */
    Counter64 getInSymbolError();
    
    /**
     * Return inSymbolError, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The number of received errored frames due to symbol error. The value refers to
     *         MIB counter for in-symbol-error oid=1.3.6.1.2.1.10.7.2.1.18
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inSymbolError, guaranteed to be non-null.
     * @throws NoSuchElementException if inSymbolError is not present
     *
     */
    default @NonNull Counter64 requireInSymbolError() {
        return CodeHelpers.require(getInSymbolError(), "insymbolerror");
    }
    
    /**
     * Return inMaxsizeExceeded, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The total number frames received that are well-formed but dropped due to
     *         exceeding the maximum frame size on the interface (e.g., MTU or MRU)
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inMaxsizeExceeded, or {@code null} if it is not present.
     *
     */
    Counter64 getInMaxsizeExceeded();
    
    /**
     * Return inMaxsizeExceeded, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The total number frames received that are well-formed but dropped due to
     *         exceeding the maximum frame size on the interface (e.g., MTU or MRU)
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} inMaxsizeExceeded, guaranteed to be non-null.
     * @throws NoSuchElementException if inMaxsizeExceeded is not present
     *
     */
    default @NonNull Counter64 requireInMaxsizeExceeded() {
        return CodeHelpers.require(getInMaxsizeExceeded(), "inmaxsizeexceeded");
    }
    
    /**
     * Return outMacControlFrames, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         MAC layer control frames sent on the interface
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} outMacControlFrames, or {@code null} if it is not present.
     *
     */
    Counter64 getOutMacControlFrames();
    
    /**
     * Return outMacControlFrames, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         MAC layer control frames sent on the interface
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} outMacControlFrames, guaranteed to be non-null.
     * @throws NoSuchElementException if outMacControlFrames is not present
     *
     */
    default @NonNull Counter64 requireOutMacControlFrames() {
        return CodeHelpers.require(getOutMacControlFrames(), "outmaccontrolframes");
    }
    
    /**
     * Return outMacPauseFrames, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         MAC layer PAUSE frames sent on the interface
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} outMacPauseFrames, or {@code null} if it is not present.
     *
     */
    Counter64 getOutMacPauseFrames();
    
    /**
     * Return outMacPauseFrames, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         MAC layer PAUSE frames sent on the interface
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} outMacPauseFrames, guaranteed to be non-null.
     * @throws NoSuchElementException if outMacPauseFrames is not present
     *
     */
    default @NonNull Counter64 requireOutMacPauseFrames() {
        return CodeHelpers.require(getOutMacPauseFrames(), "outmacpauseframes");
    }
    
    /**
     * Return out8021qFrames, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of 802.1q tagged frames sent on the interface
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} out8021qFrames, or {@code null} if it is not present.
     *
     */
    Counter64 getOut8021qFrames();
    
    /**
     * Return out8021qFrames, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of 802.1q tagged frames sent on the interface
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} out8021qFrames, guaranteed to be non-null.
     * @throws NoSuchElementException if out8021qFrames is not present
     *
     */
    default @NonNull Counter64 requireOut8021qFrames() {
        return CodeHelpers.require(getOut8021qFrames(), "out8021qframes");
    }
    
    /**
     * Return outMacErrorsTx, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The number of sent errored frames due to MAC errors transmitted. The value
     *         refers to MIB counter for dot3StatsInternalMacTransmitErrors
     *         oid=1.3.6.1.2.1.10.7.2.1.10
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} outMacErrorsTx, or {@code null} if it is not present.
     *
     */
    Counter64 getOutMacErrorsTx();
    
    /**
     * Return outMacErrorsTx, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The number of sent errored frames due to MAC errors transmitted. The value
     *         refers to MIB counter for dot3StatsInternalMacTransmitErrors
     *         oid=1.3.6.1.2.1.10.7.2.1.10
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} outMacErrorsTx, guaranteed to be non-null.
     * @throws NoSuchElementException if outMacErrorsTx is not present
     *
     */
    default @NonNull Counter64 requireOutMacErrorsTx() {
        return CodeHelpers.require(getOutMacErrorsTx(), "outmacerrorstx");
    }

}

