package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.Counters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.MacAddress;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Grouping for defining Ethernet-specific operational state
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-ethernet</b>
 * <pre>
 * grouping ethernet-interface-state {
 *   leaf hw-mac-address {
 *     type oc-yang:mac-address;
 *   }
 *   leaf negotiated-duplex-mode {
 *     type enumeration {
 *       enum FULL {
 *       }
 *       enum HALF {
 *       }
 *     }
 *   }
 *   leaf negotiated-port-speed {
 *     type identityref {
 *       base ETHERNET_SPEED;
 *     }
 *   }
 *   container counters {
 *     uses ethernet-interface-state-counters;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface EthernetInterfaceState
    extends
    DataObject
{


    @Generated("mdsal-binding-generator")
    public enum NegotiatedDuplexMode implements Enumeration {
        /**
         * Full duplex mode
         */
        FULL(0, "FULL"),
        
        /**
         * Half duplex mode
         */
        HALF(1, "HALF")
        ;
    
        private static final Map<String, NegotiatedDuplexMode> NAME_MAP;
        private static final Map<Integer, NegotiatedDuplexMode> VALUE_MAP;
    
        static {
            final Builder<String, NegotiatedDuplexMode> nb = ImmutableMap.builder();
            final Builder<Integer, NegotiatedDuplexMode> vb = ImmutableMap.builder();
            for (NegotiatedDuplexMode enumItem : NegotiatedDuplexMode.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private NegotiatedDuplexMode(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding NegotiatedDuplexMode item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<NegotiatedDuplexMode> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding NegotiatedDuplexMode item, or null if no such item exists
         */
        public static NegotiatedDuplexMode forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ethernet-interface-state");

    @Override
    Class<? extends EthernetInterfaceState> implementedInterface();
    
    /**
     * Return hwMacAddress, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Represenets the 'burned-in', or system-assigned, MAC address for the Ethernet
     *         interface.
     *     </code>
     * </pre>
     *
     * @return {@code MacAddress} hwMacAddress, or {@code null} if it is not present.
     *
     */
    MacAddress getHwMacAddress();
    
    /**
     * Return hwMacAddress, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Represenets the 'burned-in', or system-assigned, MAC address for the Ethernet
     *         interface.
     *     </code>
     * </pre>
     *
     * @return {@code MacAddress} hwMacAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if hwMacAddress is not present
     *
     */
    default @NonNull MacAddress requireHwMacAddress() {
        return CodeHelpers.require(getHwMacAddress(), "hwmacaddress");
    }
    
    /**
     * Return negotiatedDuplexMode, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When auto-negotiate is set to TRUE, and the interface has completed
     *         auto-negotiation with the remote peer, this value shows the duplex mode that has
     *         been negotiated.
     *     </code>
     * </pre>
     *
     * @return {@code NegotiatedDuplexMode} negotiatedDuplexMode, or {@code null} if it is not present.
     *
     */
    NegotiatedDuplexMode getNegotiatedDuplexMode();
    
    /**
     * Return negotiatedDuplexMode, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         When auto-negotiate is set to TRUE, and the interface has completed
     *         auto-negotiation with the remote peer, this value shows the duplex mode that has
     *         been negotiated.
     *     </code>
     * </pre>
     *
     * @return {@code NegotiatedDuplexMode} negotiatedDuplexMode, guaranteed to be non-null.
     * @throws NoSuchElementException if negotiatedDuplexMode is not present
     *
     */
    default @NonNull NegotiatedDuplexMode requireNegotiatedDuplexMode() {
        return CodeHelpers.require(getNegotiatedDuplexMode(), "negotiatedduplexmode");
    }
    
    /**
     * Return negotiatedPortSpeed, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When auto-negotiate is set to TRUE, and the interface has completed
     *         auto-negotiation with the remote peer, this value shows the interface speed that
     *         has been negotiated.
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends ETHERNETSPEED>} negotiatedPortSpeed, or {@code null} if it is not present.
     *
     */
    Class<? extends ETHERNETSPEED> getNegotiatedPortSpeed();
    
    /**
     * Return negotiatedPortSpeed, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         When auto-negotiate is set to TRUE, and the interface has completed
     *         auto-negotiation with the remote peer, this value shows the interface speed that
     *         has been negotiated.
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends ETHERNETSPEED>} negotiatedPortSpeed, guaranteed to be non-null.
     * @throws NoSuchElementException if negotiatedPortSpeed is not present
     *
     */
    default @NonNull Class<? extends ETHERNETSPEED> requireNegotiatedPortSpeed() {
        return CodeHelpers.require(getNegotiatedPortSpeed(), "negotiatedportspeed");
    }
    
    /**
     * Return counters, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Ethernet interface counters
     *     </code>
     * </pre>
     *
     * @return {@code Counters} counters, or {@code null} if it is not present.
     *
     */
    Counters getCounters();

}

