package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.aggregation.logical.top.aggregation;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.AggregationLogicalConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.AggregationLogicalState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.AggregationType;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private Uint32 _lagSpeed;
    private AggregationType _lagType;
    private Set<String> _member;
    private Uint16 _minLinks;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }
    
    
    
    public StateBuilder(AggregationLogicalConfig arg) {
        this._lagType = arg.getLagType();
        this._minLinks = arg.getMinLinks();
    }
    
    public StateBuilder(AggregationLogicalState arg) {
        this._lagSpeed = arg.getLagSpeed();
        this._member = arg.getMember();
    }

    public StateBuilder(State base) {
        Map<Class<? extends Augmentation<State>>, Augmentation<State>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._lagSpeed = base.getLagSpeed();
        this._lagType = base.getLagType();
        this._member = base.getMember();
        this._minLinks = base.getMinLinks();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>AggregationLogicalState</li>
     * <li>AggregationLogicalConfig</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AggregationLogicalState) {
            this._lagSpeed = ((AggregationLogicalState)arg).getLagSpeed();
            this._member = ((AggregationLogicalState)arg).getMember();
            isValidArg = true;
        }
        if (arg instanceof AggregationLogicalConfig) {
            this._lagType = ((AggregationLogicalConfig)arg).getLagType();
            this._minLinks = ((AggregationLogicalConfig)arg).getMinLinks();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AggregationLogicalState, AggregationLogicalConfig]");
    }

    public Uint32 getLagSpeed() {
        return _lagSpeed;
    }
    
    public AggregationType getLagType() {
        return _lagType;
    }
    
    public Set<String> getMember() {
        return _member;
    }
    
    public Uint16 getMinLinks() {
        return _minLinks;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public StateBuilder setLagSpeed(final Uint32 value) {
        this._lagSpeed = value;
        return this;
    }
    
    public StateBuilder setLagType(final AggregationType value) {
        this._lagType = value;
        return this;
    }
    public StateBuilder setMember(final Set<String> values) {
        this._member = values;
        return this;
    }
    
    
    public StateBuilder setMinLinks(final Uint16 value) {
        this._minLinks = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class<? extends Augmentation<State>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final Uint32 _lagSpeed;
        private final AggregationType _lagType;
        private final Set<String> _member;
        private final Uint16 _minLinks;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._lagSpeed = base.getLagSpeed();
            this._lagType = base.getLagType();
            this._member = base.getMember();
            this._minLinks = base.getMinLinks();
        }
    
        @Override
        public Uint32 getLagSpeed() {
            return _lagSpeed;
        }
        
        @Override
        public AggregationType getLagType() {
            return _lagType;
        }
        
        @Override
        public Set<String> getMember() {
            return _member;
        }
        
        @Override
        public Uint16 getMinLinks() {
            return _minLinks;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
