package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.Alarms;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.alarm.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.alarm.State;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * List of alarms, keyed by a unique id
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-alarms</b>
 * <pre>
 * list alarm {
 *   key id;
 *   leaf id {
 *     type leafref {
 *       path ../state/id;
 *     }
 *   }
 *   container config {
 *     uses alarm-config;
 *   }
 *   container state {
 *     config false;
 *     uses alarm-config;
 *     uses alarm-state;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link AlarmBuilder}.
 * @see AlarmBuilder
 * @see AlarmKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Alarm
    extends
    ChildOf<Alarms>,
    Augmentable<Alarm>,
    Identifiable<AlarmKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("alarm");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.Alarm> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.Alarm.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.@NonNull Alarm obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getConfig());
        result = prime * result + Objects.hashCode(obj.getId());
        result = prime * result + Objects.hashCode(obj.getState());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.@NonNull Alarm thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.Alarm other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.Alarm.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getId(), other.getId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getConfig(), other.getConfig())) {
            return false;
        }
        if (!Objects.equals(thisObj.getState(), other.getState())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.@NonNull Alarm obj) {
        final var helper = MoreObjects.toStringHelper("Alarm");
        CodeHelpers.appendValue(helper, "config", obj.getConfig());
        CodeHelpers.appendValue(helper, "id", obj.getId());
        CodeHelpers.appendValue(helper, "state", obj.getState());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    AlarmKey key();
    
    /**
     * Return id, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         References the unique alarm id
     *     </code>
     * </pre>
     *
     * @return {@code String} id, or {@code null} if it is not present.
     *
     */
    String getId();
    
    /**
     * Return id, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         References the unique alarm id
     *     </code>
     * </pre>
     *
     * @return {@code String} id, guaranteed to be non-null.
     * @throws NoSuchElementException if id is not present
     *
     */
    default @NonNull String requireId() {
        return CodeHelpers.require(getId(), "id");
    }
    
    /**
     * Return config, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Configuration data for each alarm
     *     </code>
     * </pre>
     *
     * @return {@code Config} config, or {@code null} if it is not present.
     *
     */
    Config getConfig();
    
    /**
     * Return state, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Operational state data for a device alarm
     *     </code>
     * </pre>
     *
     * @return {@code State} state, or {@code null} if it is not present.
     *
     */
    State getState();

}

