package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.top.radius;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaRadiusServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaRadiusServerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.state.Counters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.CryptPasswordType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.RoutingPassword;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private PortNumber _acctPort;
    private PortNumber _authPort;
    private Counters _counters;
    private Uint8 _retransmitAttempts;
    private RoutingPassword _secretKey;
    private CryptPasswordType _secretKeyHashed;
    private IpAddress _sourceAddress;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }
    
    
    
    public StateBuilder(AaaRadiusServerConfig arg) {
        this._authPort = arg.getAuthPort();
        this._acctPort = arg.getAcctPort();
        this._secretKey = arg.getSecretKey();
        this._secretKeyHashed = arg.getSecretKeyHashed();
        this._sourceAddress = arg.getSourceAddress();
        this._retransmitAttempts = arg.getRetransmitAttempts();
    }
    
    public StateBuilder(AaaRadiusServerState arg) {
        this._counters = arg.getCounters();
    }

    public StateBuilder(State base) {
        Map<Class<? extends Augmentation<State>>, Augmentation<State>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._acctPort = base.getAcctPort();
        this._authPort = base.getAuthPort();
        this._counters = base.getCounters();
        this._retransmitAttempts = base.getRetransmitAttempts();
        this._secretKey = base.getSecretKey();
        this._secretKeyHashed = base.getSecretKeyHashed();
        this._sourceAddress = base.getSourceAddress();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>AaaRadiusServerConfig</li>
     * <li>AaaRadiusServerState</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaRadiusServerConfig) {
            this._authPort = ((AaaRadiusServerConfig)arg).getAuthPort();
            this._acctPort = ((AaaRadiusServerConfig)arg).getAcctPort();
            this._secretKey = ((AaaRadiusServerConfig)arg).getSecretKey();
            this._secretKeyHashed = ((AaaRadiusServerConfig)arg).getSecretKeyHashed();
            this._sourceAddress = ((AaaRadiusServerConfig)arg).getSourceAddress();
            this._retransmitAttempts = ((AaaRadiusServerConfig)arg).getRetransmitAttempts();
            isValidArg = true;
        }
        if (arg instanceof AaaRadiusServerState) {
            this._counters = ((AaaRadiusServerState)arg).getCounters();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AaaRadiusServerConfig, AaaRadiusServerState]");
    }

    public PortNumber getAcctPort() {
        return _acctPort;
    }
    
    public PortNumber getAuthPort() {
        return _authPort;
    }
    
    public Counters getCounters() {
        return _counters;
    }
    
    public Uint8 getRetransmitAttempts() {
        return _retransmitAttempts;
    }
    
    public RoutingPassword getSecretKey() {
        return _secretKey;
    }
    
    public CryptPasswordType getSecretKeyHashed() {
        return _secretKeyHashed;
    }
    
    public IpAddress getSourceAddress() {
        return _sourceAddress;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public StateBuilder setAcctPort(final PortNumber value) {
        this._acctPort = value;
        return this;
    }
    
    public StateBuilder setAuthPort(final PortNumber value) {
        this._authPort = value;
        return this;
    }
    
    public StateBuilder setCounters(final Counters value) {
        this._counters = value;
        return this;
    }
    
    public StateBuilder setRetransmitAttempts(final Uint8 value) {
        this._retransmitAttempts = value;
        return this;
    }
    
    public StateBuilder setSecretKey(final RoutingPassword value) {
        this._secretKey = value;
        return this;
    }
    
    public StateBuilder setSecretKeyHashed(final CryptPasswordType value) {
        this._secretKeyHashed = value;
        return this;
    }
    
    public StateBuilder setSourceAddress(final IpAddress value) {
        this._sourceAddress = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class<? extends Augmentation<State>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final PortNumber _acctPort;
        private final PortNumber _authPort;
        private final Counters _counters;
        private final Uint8 _retransmitAttempts;
        private final RoutingPassword _secretKey;
        private final CryptPasswordType _secretKeyHashed;
        private final IpAddress _sourceAddress;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._acctPort = base.getAcctPort();
            this._authPort = base.getAuthPort();
            this._counters = base.getCounters();
            this._retransmitAttempts = base.getRetransmitAttempts();
            this._secretKey = base.getSecretKey();
            this._secretKeyHashed = base.getSecretKeyHashed();
            this._sourceAddress = base.getSourceAddress();
        }
    
        @Override
        public PortNumber getAcctPort() {
            return _acctPort;
        }
        
        @Override
        public PortNumber getAuthPort() {
            return _authPort;
        }
        
        @Override
        public Counters getCounters() {
            return _counters;
        }
        
        @Override
        public Uint8 getRetransmitAttempts() {
            return _retransmitAttempts;
        }
        
        @Override
        public RoutingPassword getSecretKey() {
            return _secretKey;
        }
        
        @Override
        public CryptPasswordType getSecretKeyHashed() {
            return _secretKeyHashed;
        }
        
        @Override
        public IpAddress getSourceAddress() {
            return _sourceAddress;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
