package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.CryptPasswordType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.RoutingPassword;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for a TACACS+ server
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-tacacs-server-config {
 *   leaf port {
 *     type oc-inet:port-number;
 *     default 49;
 *   }
 *   leaf secret-key {
 *     type oc-types:routing-password;
 *   }
 *   leaf secret-key-hashed {
 *     type oc-aaa-types:crypt-password-type;
 *   }
 *   leaf source-address {
 *     type oc-inet:ip-address;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaTacacsServerConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-tacacs-server-config");

    @Override
    Class<? extends AaaTacacsServerConfig> implementedInterface();
    
    /**
     * Return port, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The port number on which to contact the TACACS server
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} port, or {@code null} if it is not present.
     *
     */
    PortNumber getPort();
    
    /**
     * Return port, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The port number on which to contact the TACACS server
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} port, guaranteed to be non-null.
     * @throws NoSuchElementException if port is not present
     *
     */
    default @NonNull PortNumber requirePort() {
        return CodeHelpers.require(getPort(), "port");
    }
    
    /**
     * Return secretKey, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The unencrypted shared key used between the authentication server and the
     *         device.
     *     </code>
     * </pre>
     *
     * @return {@code RoutingPassword} secretKey, or {@code null} if it is not present.
     *
     */
    RoutingPassword getSecretKey();
    
    /**
     * Return secretKey, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The unencrypted shared key used between the authentication server and the
     *         device.
     *     </code>
     * </pre>
     *
     * @return {@code RoutingPassword} secretKey, guaranteed to be non-null.
     * @throws NoSuchElementException if secretKey is not present
     *
     */
    default @NonNull RoutingPassword requireSecretKey() {
        return CodeHelpers.require(getSecretKey(), "secretkey");
    }
    
    /**
     * Return secretKeyHashed, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The hashed shared key used between the authentication server and the device.
     *     </code>
     * </pre>
     *
     * @return {@code CryptPasswordType} secretKeyHashed, or {@code null} if it is not present.
     *
     */
    CryptPasswordType getSecretKeyHashed();
    
    /**
     * Return secretKeyHashed, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The hashed shared key used between the authentication server and the device.
     *     </code>
     * </pre>
     *
     * @return {@code CryptPasswordType} secretKeyHashed, guaranteed to be non-null.
     * @throws NoSuchElementException if secretKeyHashed is not present
     *
     */
    default @NonNull CryptPasswordType requireSecretKeyHashed() {
        return CodeHelpers.require(getSecretKeyHashed(), "secretkeyhashed");
    }
    
    /**
     * Return sourceAddress, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Source IP address to use in messages to the TACACS server
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} sourceAddress, or {@code null} if it is not present.
     *
     */
    IpAddress getSourceAddress();
    
    /**
     * Return sourceAddress, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Source IP address to use in messages to the TACACS server
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} sourceAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if sourceAddress is not present
     *
     */
    default @NonNull IpAddress requireSourceAddress() {
        return CodeHelpers.require(getSourceAddress(), "sourceaddress");
    }

}

