package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Counter64;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Common operational state data for AAA servers
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-server-state {
 *   leaf connection-opens {
 *     type oc-yang:counter64;
 *   }
 *   leaf connection-closes {
 *     type oc-yang:counter64;
 *   }
 *   leaf connection-aborts {
 *     type oc-yang:counter64;
 *   }
 *   leaf connection-failures {
 *     type oc-yang:counter64;
 *   }
 *   leaf connection-timeouts {
 *     type oc-yang:counter64;
 *   }
 *   leaf messages-sent {
 *     type oc-yang:counter64;
 *   }
 *   leaf messages-received {
 *     type oc-yang:counter64;
 *   }
 *   leaf errors-received {
 *     type oc-yang:counter64;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaServerState
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-server-state");

    @Override
    Class<? extends AaaServerState> implementedInterface();
    
    /**
     * Return connectionOpens, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of new connection requests sent to the server, e.g. socket open
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} connectionOpens, or {@code null} if it is not present.
     *
     */
    Counter64 getConnectionOpens();
    
    /**
     * Return connectionOpens, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of new connection requests sent to the server, e.g. socket open
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} connectionOpens, guaranteed to be non-null.
     * @throws NoSuchElementException if connectionOpens is not present
     *
     */
    default @NonNull Counter64 requireConnectionOpens() {
        return CodeHelpers.require(getConnectionOpens(), "connectionopens");
    }
    
    /**
     * Return connectionCloses, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of connection close requests sent to the server, e.g. socket close
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} connectionCloses, or {@code null} if it is not present.
     *
     */
    Counter64 getConnectionCloses();
    
    /**
     * Return connectionCloses, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of connection close requests sent to the server, e.g. socket close
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} connectionCloses, guaranteed to be non-null.
     * @throws NoSuchElementException if connectionCloses is not present
     *
     */
    default @NonNull Counter64 requireConnectionCloses() {
        return CodeHelpers.require(getConnectionCloses(), "connectioncloses");
    }
    
    /**
     * Return connectionAborts, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of aborted connections to the server. These do not include connections
     *         that are close gracefully.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} connectionAborts, or {@code null} if it is not present.
     *
     */
    Counter64 getConnectionAborts();
    
    /**
     * Return connectionAborts, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of aborted connections to the server. These do not include connections
     *         that are close gracefully.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} connectionAborts, guaranteed to be non-null.
     * @throws NoSuchElementException if connectionAborts is not present
     *
     */
    default @NonNull Counter64 requireConnectionAborts() {
        return CodeHelpers.require(getConnectionAborts(), "connectionaborts");
    }
    
    /**
     * Return connectionFailures, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of connection failures to the server
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} connectionFailures, or {@code null} if it is not present.
     *
     */
    Counter64 getConnectionFailures();
    
    /**
     * Return connectionFailures, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of connection failures to the server
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} connectionFailures, guaranteed to be non-null.
     * @throws NoSuchElementException if connectionFailures is not present
     *
     */
    default @NonNull Counter64 requireConnectionFailures() {
        return CodeHelpers.require(getConnectionFailures(), "connectionfailures");
    }
    
    /**
     * Return connectionTimeouts, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of connection timeouts to the server
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} connectionTimeouts, or {@code null} if it is not present.
     *
     */
    Counter64 getConnectionTimeouts();
    
    /**
     * Return connectionTimeouts, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of connection timeouts to the server
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} connectionTimeouts, guaranteed to be non-null.
     * @throws NoSuchElementException if connectionTimeouts is not present
     *
     */
    default @NonNull Counter64 requireConnectionTimeouts() {
        return CodeHelpers.require(getConnectionTimeouts(), "connectiontimeouts");
    }
    
    /**
     * Return messagesSent, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of messages sent to the server
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} messagesSent, or {@code null} if it is not present.
     *
     */
    Counter64 getMessagesSent();
    
    /**
     * Return messagesSent, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of messages sent to the server
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} messagesSent, guaranteed to be non-null.
     * @throws NoSuchElementException if messagesSent is not present
     *
     */
    default @NonNull Counter64 requireMessagesSent() {
        return CodeHelpers.require(getMessagesSent(), "messagessent");
    }
    
    /**
     * Return messagesReceived, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of messages received by the server
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} messagesReceived, or {@code null} if it is not present.
     *
     */
    Counter64 getMessagesReceived();
    
    /**
     * Return messagesReceived, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of messages received by the server
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} messagesReceived, guaranteed to be non-null.
     * @throws NoSuchElementException if messagesReceived is not present
     *
     */
    default @NonNull Counter64 requireMessagesReceived() {
        return CodeHelpers.require(getMessagesReceived(), "messagesreceived");
    }
    
    /**
     * Return errorsReceived, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of error messages received from the server
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} errorsReceived, or {@code null} if it is not present.
     *
     */
    Counter64 getErrorsReceived();
    
    /**
     * Return errorsReceived, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of error messages received from the server
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} errorsReceived, guaranteed to be non-null.
     * @throws NoSuchElementException if errorsReceived is not present
     *
     */
    default @NonNull Counter64 requireErrorsReceived() {
        return CodeHelpers.require(getErrorsReceived(), "errorsreceived");
    }

}

