package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Common configuration data for AAA servers
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-server-config {
 *   leaf name {
 *     type string;
 *   }
 *   leaf address {
 *     type oc-inet:ip-address;
 *   }
 *   leaf timeout {
 *     type uint16;
 *     units seconds;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaServerConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-server-config");

    @Override
    Class<? extends AaaServerConfig> implementedInterface();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Name assigned to the server
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Name assigned to the server
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return address, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Address of the authentication server
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} address, or {@code null} if it is not present.
     *
     */
    IpAddress getAddress();
    
    /**
     * Return address, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Address of the authentication server
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} address, guaranteed to be non-null.
     * @throws NoSuchElementException if address is not present
     *
     */
    default @NonNull IpAddress requireAddress() {
        return CodeHelpers.require(getAddress(), "address");
    }
    
    /**
     * Return timeout, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Set the timeout in seconds on responses from the AAA server
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} timeout, or {@code null} if it is not present.
     *
     */
    Uint16 getTimeout();
    
    /**
     * Return timeout, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Set the timeout in seconds on responses from the AAA server
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} timeout, guaranteed to be non-null.
     * @throws NoSuchElementException if timeout is not present
     *
     */
    default @NonNull Uint16 requireTimeout() {
        return CodeHelpers.require(getTimeout(), "timeout");
    }

}

