package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.admin.top.AdminUser;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for root user configuration and state data
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-authentication-admin-top {
 *   container admin-user {
 *     container config {
 *       uses aaa-admin-config;
 *     }
 *     container state {
 *       config false;
 *       uses aaa-admin-config;
 *       uses aaa-admin-state;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAuthenticationAdminTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-authentication-admin-top");

    @Override
    Class<? extends AaaAuthenticationAdminTop> implementedInterface();
    
    /**
     * Return adminUser, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for the system root or admin user configuration and
     *         operational state
     *     </code>
     * </pre>
     *
     * @return {@code AdminUser} adminUser, or {@code null} if it is not present.
     *
     */
    AdminUser getAdminUser();

}

