/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.vlan;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.vlan.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder
implements Builder<Config> {
    private String _name;
    private VlanConfig.Status _status;
    private VlanId _vlanId;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }

    public ConfigBuilder(VlanConfig arg) {
        this._vlanId = arg.getVlanId();
        this._name = arg.getName();
        this._status = arg.getStatus();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._name = base.getName();
        this._status = base.getStatus();
        this._vlanId = base.getVlanId();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanConfig) {
            this._vlanId = ((VlanConfig)arg).getVlanId();
            this._name = ((VlanConfig)arg).getName();
            this._status = ((VlanConfig)arg).getStatus();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[VlanConfig]");
    }

    public String getName() {
        return this._name;
    }

    public VlanConfig.Status getStatus() {
        return this._status;
    }

    public VlanId getVlanId() {
        return this._vlanId;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ConfigBuilder setStatus(VlanConfig.Status value) {
        this._status = value;
        return this;
    }

    public ConfigBuilder setVlanId(VlanId value) {
        this._vlanId = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final String _name;
        private final VlanConfig.Status _status;
        private final VlanId _vlanId;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._name = base.getName();
            this._status = base.getStatus();
            this._vlanId = base.getVlanId();
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public VlanConfig.Status getStatus() {
            return this._status;
        }

        @Override
        public VlanId getVlanId() {
            return this._vlanId;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

