/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.outer.range;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanLogicalDoubleTaggedOuterRangeConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.outer.range.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder
implements Builder<Config> {
    private VlanId _innerVlanId;
    private VlanId _outerHighVlanId;
    private VlanId _outerLowVlanId;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }

    public ConfigBuilder(VlanLogicalDoubleTaggedOuterRangeConfig arg) {
        this._innerVlanId = arg.getInnerVlanId();
        this._outerLowVlanId = arg.getOuterLowVlanId();
        this._outerHighVlanId = arg.getOuterHighVlanId();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._innerVlanId = base.getInnerVlanId();
        this._outerHighVlanId = base.getOuterHighVlanId();
        this._outerLowVlanId = base.getOuterLowVlanId();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanLogicalDoubleTaggedOuterRangeConfig) {
            this._innerVlanId = ((VlanLogicalDoubleTaggedOuterRangeConfig)arg).getInnerVlanId();
            this._outerLowVlanId = ((VlanLogicalDoubleTaggedOuterRangeConfig)arg).getOuterLowVlanId();
            this._outerHighVlanId = ((VlanLogicalDoubleTaggedOuterRangeConfig)arg).getOuterHighVlanId();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[VlanLogicalDoubleTaggedOuterRangeConfig]");
    }

    public VlanId getInnerVlanId() {
        return this._innerVlanId;
    }

    public VlanId getOuterHighVlanId() {
        return this._outerHighVlanId;
    }

    public VlanId getOuterLowVlanId() {
        return this._outerLowVlanId;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setInnerVlanId(VlanId value) {
        this._innerVlanId = value;
        return this;
    }

    public ConfigBuilder setOuterHighVlanId(VlanId value) {
        this._outerHighVlanId = value;
        return this;
    }

    public ConfigBuilder setOuterLowVlanId(VlanId value) {
        this._outerLowVlanId = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final VlanId _innerVlanId;
        private final VlanId _outerHighVlanId;
        private final VlanId _outerLowVlanId;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._innerVlanId = base.getInnerVlanId();
            this._outerHighVlanId = base.getOuterHighVlanId();
            this._outerLowVlanId = base.getOuterLowVlanId();
        }

        @Override
        public VlanId getInnerVlanId() {
            return this._innerVlanId;
        }

        @Override
        public VlanId getOuterHighVlanId() {
            return this._outerHighVlanId;
        }

        @Override
        public VlanId getOuterLowVlanId() {
            return this._outerLowVlanId;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

