/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanModeType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanRange;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

public interface VlanSwitchedConfig
extends DataObject {
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-switched-config");

    public Class<? extends VlanSwitchedConfig> implementedInterface();

    public VlanModeType getInterfaceMode();

    default public @NonNull VlanModeType requireInterfaceMode() {
        return (VlanModeType)((Object)CodeHelpers.require((Object)((Object)this.getInterfaceMode()), (String)"interfacemode"));
    }

    public VlanId getNativeVlan();

    default public @NonNull VlanId requireNativeVlan() {
        return (VlanId)CodeHelpers.require((Object)this.getNativeVlan(), (String)"nativevlan");
    }

    public VlanId getAccessVlan();

    default public @NonNull VlanId requireAccessVlan() {
        return (VlanId)CodeHelpers.require((Object)this.getAccessVlan(), (String)"accessvlan");
    }

    public @Nullable List<TrunkVlans> getTrunkVlans();

    default public @NonNull List<TrunkVlans> requireTrunkVlans() {
        return (List)CodeHelpers.require(this.getTrunkVlans(), (String)"trunkvlans");
    }

    public static final class TrunkVlans
    implements TypeObject,
    Serializable {
        private static final long serialVersionUID = 4696041022428618626L;
        public static final List<String> PATTERN_CONSTANTS = ImmutableList.of((Object)"^(?:\\^(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.\\.(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\$)$");
        private static final Pattern patterns = Pattern.compile(PATTERN_CONSTANTS.get(0));
        private static final String regexes = "^(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.\\.(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])$";
        private final VlanId _vlanId;
        private final VlanRange _vlanRange;

        public TrunkVlans(VlanId _vlanId) {
            this._vlanId = _vlanId;
            this._vlanRange = null;
        }

        public TrunkVlans(VlanRange _vlanRange) {
            this._vlanRange = _vlanRange;
            this._vlanId = null;
        }

        public TrunkVlans(TrunkVlans source) {
            this._vlanId = source._vlanId;
            this._vlanRange = source._vlanRange;
        }

        public String stringValue() {
            if (this._vlanId != null) {
                return this._vlanId.getValue().toString();
            }
            if (this._vlanRange != null) {
                return this._vlanRange.getValue().toString();
            }
            throw new IllegalStateException("No value assinged");
        }

        public VlanId getVlanId() {
            return this._vlanId;
        }

        public VlanRange getVlanRange() {
            return this._vlanRange;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._vlanId);
            result = 31 * result + Objects.hashCode(this._vlanRange);
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TrunkVlans)) {
                return false;
            }
            TrunkVlans other = (TrunkVlans)obj;
            if (!Objects.equals(this._vlanId, other._vlanId)) {
                return false;
            }
            return Objects.equals(this._vlanRange, other._vlanRange);
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(TrunkVlans.class);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_vlanId", (Object)this._vlanId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_vlanRange", (Object)this._vlanRange);
            return helper.toString();
        }
    }
}

