/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.terminal.common.top.terminal.servers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemTerminalCommonConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.terminal.common.top.terminal.servers.Config;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

public class ConfigBuilder
implements Builder<Config> {
    private Uint16 _rateLimit;
    private Uint16 _sessionLimit;
    private Uint16 _timeout;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }

    public ConfigBuilder(SystemTerminalCommonConfig arg) {
        this._timeout = arg.getTimeout();
        this._rateLimit = arg.getRateLimit();
        this._sessionLimit = arg.getSessionLimit();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._rateLimit = base.getRateLimit();
        this._sessionLimit = base.getSessionLimit();
        this._timeout = base.getTimeout();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemTerminalCommonConfig) {
            this._timeout = ((SystemTerminalCommonConfig)arg).getTimeout();
            this._rateLimit = ((SystemTerminalCommonConfig)arg).getRateLimit();
            this._sessionLimit = ((SystemTerminalCommonConfig)arg).getSessionLimit();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemTerminalCommonConfig]");
    }

    public Uint16 getRateLimit() {
        return this._rateLimit;
    }

    public Uint16 getSessionLimit() {
        return this._sessionLimit;
    }

    public Uint16 getTimeout() {
        return this._timeout;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setRateLimit(Uint16 value) {
        this._rateLimit = value;
        return this;
    }

    public ConfigBuilder setSessionLimit(Uint16 value) {
        this._sessionLimit = value;
        return this;
    }

    public ConfigBuilder setTimeout(Uint16 value) {
        this._timeout = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final Uint16 _rateLimit;
        private final Uint16 _sessionLimit;
        private final Uint16 _timeout;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._rateLimit = base.getRateLimit();
            this._sessionLimit = base.getSessionLimit();
            this._timeout = base.getTimeout();
        }

        @Override
        public Uint16 getRateLimit() {
            return this._rateLimit;
        }

        @Override
        public Uint16 getSessionLimit() {
            return this._sessionLimit;
        }

        @Override
        public Uint16 getTimeout() {
            return this._timeout;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

