/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.subcomponents;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.subcomponents.Subcomponent;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.subcomponents.SubcomponentKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.subcomponents.subcomponent.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.subcomponents.subcomponent.State;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class SubcomponentBuilder
implements Builder<Subcomponent> {
    private Config _config;
    private Object _name;
    private State _state;
    private SubcomponentKey key;
    Map<Class<? extends Augmentation<Subcomponent>>, Augmentation<Subcomponent>> augmentation = Collections.emptyMap();

    public SubcomponentBuilder() {
    }

    public SubcomponentBuilder(Subcomponent base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Subcomponent>>, Augmentation<Subcomponent>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public SubcomponentKey key() {
        return this.key;
    }

    public Config getConfig() {
        return this._config;
    }

    public Object getName() {
        return this._name;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Subcomponent>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public SubcomponentBuilder withKey(SubcomponentKey key) {
        this.key = key;
        return this;
    }

    public SubcomponentBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public SubcomponentBuilder setName(Object value) {
        this._name = value;
        return this;
    }

    public SubcomponentBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public SubcomponentBuilder addAugmentation(Augmentation<Subcomponent> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Subcomponent>>, Augmentation<Subcomponent>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SubcomponentBuilder removeAugmentation(Class<? extends Augmentation<Subcomponent>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Subcomponent build() {
        return new SubcomponentImpl(this);
    }

    private static final class SubcomponentImpl
    extends AbstractAugmentable<Subcomponent>
    implements Subcomponent {
        private final Config _config;
        private final Object _name;
        private final State _state;
        private final SubcomponentKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SubcomponentImpl(SubcomponentBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new SubcomponentKey(base.getName());
            this._name = this.key.getName();
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public SubcomponentKey key() {
            return this.key;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public Object getName() {
            return this._name;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Subcomponent.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Subcomponent.bindingEquals(this, obj);
        }

        public String toString() {
            return Subcomponent.bindingToString(this);
        }
    }
}

