/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.properties;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.properties.Property;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.properties.PropertyKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.properties.property.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.properties.property.State;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class PropertyBuilder
implements Builder<Property> {
    private Config _config;
    private String _name;
    private State _state;
    private PropertyKey key;
    Map<Class<? extends Augmentation<Property>>, Augmentation<Property>> augmentation = Collections.emptyMap();

    public PropertyBuilder() {
    }

    public PropertyBuilder(Property base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Property>>, Augmentation<Property>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public PropertyKey key() {
        return this.key;
    }

    public Config getConfig() {
        return this._config;
    }

    public String getName() {
        return this._name;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Property>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PropertyBuilder withKey(PropertyKey key) {
        this.key = key;
        return this;
    }

    public PropertyBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public PropertyBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public PropertyBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public PropertyBuilder addAugmentation(Augmentation<Property> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Property>>, Augmentation<Property>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PropertyBuilder removeAugmentation(Class<? extends Augmentation<Property>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Property build() {
        return new PropertyImpl(this);
    }

    private static final class PropertyImpl
    extends AbstractAugmentable<Property>
    implements Property {
        private final Config _config;
        private final String _name;
        private final State _state;
        private final PropertyKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PropertyImpl(PropertyBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new PropertyKey(base.getName());
            this._name = this.key.getName();
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public PropertyKey key() {
            return this.key;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Property.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Property.bindingEquals(this, obj);
        }

        public String toString() {
            return Property.bindingToString(this);
        }
    }
}

