/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.memory.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.memory.state.Memory;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint64;

public class MemoryBuilder
implements Builder<Memory> {
    private Uint64 _available;
    private Uint64 _utilized;
    Map<Class<? extends Augmentation<Memory>>, Augmentation<Memory>> augmentation = Collections.emptyMap();

    public MemoryBuilder() {
    }

    public MemoryBuilder(Memory base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Memory>>, Augmentation<Memory>>(aug);
        }
        this._available = base.getAvailable();
        this._utilized = base.getUtilized();
    }

    public Uint64 getAvailable() {
        return this._available;
    }

    public Uint64 getUtilized() {
        return this._utilized;
    }

    public <E$$ extends Augmentation<Memory>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MemoryBuilder setAvailable(Uint64 value) {
        this._available = value;
        return this;
    }

    public MemoryBuilder setUtilized(Uint64 value) {
        this._utilized = value;
        return this;
    }

    public MemoryBuilder addAugmentation(Augmentation<Memory> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Memory>>, Augmentation<Memory>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MemoryBuilder removeAugmentation(Class<? extends Augmentation<Memory>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Memory build() {
        return new MemoryImpl(this);
    }

    private static final class MemoryImpl
    extends AbstractAugmentable<Memory>
    implements Memory {
        private final Uint64 _available;
        private final Uint64 _utilized;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MemoryImpl(MemoryBuilder base) {
            super(base.augmentation);
            this._available = base.getAvailable();
            this._utilized = base.getUtilized();
        }

        @Override
        public Uint64 getAvailable() {
            return this._available;
        }

        @Override
        public Uint64 getUtilized() {
            return this._utilized;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Memory.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Memory.bindingEquals(this, obj);
        }

        public String toString() {
            return Memory.bindingToString(this);
        }
    }
}

