/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Storage;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.storage.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.storage.State;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class StorageBuilder
implements Builder<Storage> {
    private Config _config;
    private State _state;
    Map<Class<? extends Augmentation<Storage>>, Augmentation<Storage>> augmentation = Collections.emptyMap();

    public StorageBuilder() {
    }

    public StorageBuilder(Storage base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Storage>>, Augmentation<Storage>>(aug);
        }
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public Config getConfig() {
        return this._config;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Storage>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StorageBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public StorageBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public StorageBuilder addAugmentation(Augmentation<Storage> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Storage>>, Augmentation<Storage>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StorageBuilder removeAugmentation(Class<? extends Augmentation<Storage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Storage build() {
        return new StorageImpl(this);
    }

    private static final class StorageImpl
    extends AbstractAugmentable<Storage>
    implements Storage {
        private final Config _config;
        private final State _state;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StorageImpl(StorageBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Storage.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Storage.bindingEquals(this, obj);
        }

        public String toString() {
            return Storage.bindingToString(this);
        }
    }
}

