/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Fabric;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.fabric.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.fabric.State;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class FabricBuilder
implements Builder<Fabric> {
    private Config _config;
    private State _state;
    Map<Class<? extends Augmentation<Fabric>>, Augmentation<Fabric>> augmentation = Collections.emptyMap();

    public FabricBuilder() {
    }

    public FabricBuilder(Fabric base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Fabric>>, Augmentation<Fabric>>(aug);
        }
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public Config getConfig() {
        return this._config;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Fabric>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public FabricBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public FabricBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public FabricBuilder addAugmentation(Augmentation<Fabric> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Fabric>>, Augmentation<Fabric>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FabricBuilder removeAugmentation(Class<? extends Augmentation<Fabric>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Fabric build() {
        return new FabricImpl(this);
    }

    private static final class FabricImpl
    extends AbstractAugmentable<Fabric>
    implements Fabric {
        private final Config _config;
        private final State _state;
        private int hash = 0;
        private volatile boolean hashValid = false;

        FabricImpl(FabricBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Fabric.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Fabric.bindingEquals(this, obj);
        }

        public String toString() {
            return Fabric.bindingToString(this);
        }
    }
}

