/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.License;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.LicenseKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.license.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.license.State;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class LicenseBuilder
implements Builder<License> {
    private Config _config;
    private String _licenseId;
    private State _state;
    private LicenseKey key;
    Map<Class<? extends Augmentation<License>>, Augmentation<License>> augmentation = Collections.emptyMap();

    public LicenseBuilder() {
    }

    public LicenseBuilder(License base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<License>>, Augmentation<License>>(aug);
        }
        this.key = base.key();
        this._licenseId = base.getLicenseId();
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public LicenseKey key() {
        return this.key;
    }

    public Config getConfig() {
        return this._config;
    }

    public String getLicenseId() {
        return this._licenseId;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<License>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public LicenseBuilder withKey(LicenseKey key) {
        this.key = key;
        return this;
    }

    public LicenseBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public LicenseBuilder setLicenseId(String value) {
        this._licenseId = value;
        return this;
    }

    public LicenseBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public LicenseBuilder addAugmentation(Augmentation<License> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<License>>, Augmentation<License>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LicenseBuilder removeAugmentation(Class<? extends Augmentation<License>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public License build() {
        return new LicenseImpl(this);
    }

    private static final class LicenseImpl
    extends AbstractAugmentable<License>
    implements License {
        private final Config _config;
        private final String _licenseId;
        private final State _state;
        private final LicenseKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        LicenseImpl(LicenseBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new LicenseKey(base.getLicenseId());
            this._licenseId = this.key.getLicenseId();
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public LicenseKey key() {
            return this.key;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public String getLicenseId() {
            return this._licenseId;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = License.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return License.bindingEquals(this, obj);
        }

        public String toString() {
            return License.bindingToString(this);
        }
    }
}

