/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.subinterfaces.top.subinterfaces.subinterface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfaceCommonConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.SubinterfacesConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.subinterfaces.top.subinterfaces.subinterface.Config;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class ConfigBuilder
implements Builder<Config> {
    private String _description;
    private Boolean _enabled;
    private Uint32 _index;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }

    public ConfigBuilder(SubinterfacesConfig arg) {
        this._index = arg.getIndex();
        this._description = arg.getDescription();
        this._enabled = arg.getEnabled();
    }

    public ConfigBuilder(InterfaceCommonConfig arg) {
        this._description = arg.getDescription();
        this._enabled = arg.getEnabled();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._description = base.getDescription();
        this._enabled = base.getEnabled();
        this._index = base.getIndex();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SubinterfacesConfig) {
            this._index = ((SubinterfacesConfig)arg).getIndex();
            isValidArg = true;
        }
        if (arg instanceof InterfaceCommonConfig) {
            this._description = ((InterfaceCommonConfig)arg).getDescription();
            this._enabled = ((InterfaceCommonConfig)arg).getEnabled();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SubinterfacesConfig, InterfaceCommonConfig]");
    }

    public String getDescription() {
        return this._description;
    }

    public Boolean getEnabled() {
        return this._enabled;
    }

    public Uint32 getIndex() {
        return this._index;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public ConfigBuilder setEnabled(Boolean value) {
        this._enabled = value;
        return this;
    }

    public ConfigBuilder setIndex(Uint32 value) {
        this._index = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final String _description;
        private final Boolean _enabled;
        private final Uint32 _index;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._description = base.getDescription();
            this._enabled = base.getEnabled();
            this._index = base.getIndex();
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public Boolean getEnabled() {
            return this._enabled;
        }

        @Override
        public Uint32 getIndex() {
            return this._index;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

