/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.Alarm;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.AlarmKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.alarm.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.alarm.State;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class AlarmBuilder
implements Builder<Alarm> {
    private Config _config;
    private String _id;
    private State _state;
    private AlarmKey key;
    Map<Class<? extends Augmentation<Alarm>>, Augmentation<Alarm>> augmentation = Collections.emptyMap();

    public AlarmBuilder() {
    }

    public AlarmBuilder(Alarm base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Alarm>>, Augmentation<Alarm>>(aug);
        }
        this.key = base.key();
        this._id = base.getId();
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public AlarmKey key() {
        return this.key;
    }

    public Config getConfig() {
        return this._config;
    }

    public String getId() {
        return this._id;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Alarm>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public AlarmBuilder withKey(AlarmKey key) {
        this.key = key;
        return this;
    }

    public AlarmBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public AlarmBuilder setId(String value) {
        this._id = value;
        return this;
    }

    public AlarmBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public AlarmBuilder addAugmentation(Augmentation<Alarm> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Alarm>>, Augmentation<Alarm>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public AlarmBuilder removeAugmentation(Class<? extends Augmentation<Alarm>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Alarm build() {
        return new AlarmImpl(this);
    }

    private static final class AlarmImpl
    extends AbstractAugmentable<Alarm>
    implements Alarm {
        private final Config _config;
        private final String _id;
        private final State _state;
        private final AlarmKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        AlarmImpl(AlarmBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new AlarmKey(base.getId());
            this._id = this.key.getId();
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public AlarmKey key() {
            return this.key;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public String getId() {
            return this._id;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Alarm.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Alarm.bindingEquals(this, obj);
        }

        public String toString() {
            return Alarm.bindingToString(this);
        }
    }
}

