package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

@Generated("mdsal-binding-generator")
public class VlanRef
 implements TypeObject, Serializable {
    private static final long serialVersionUID = 8797914716729069812L;
    private final VlanId _vlanId;
    private final String _string;


    public VlanRef(VlanId _vlanId) {
        super();
        this._vlanId = _vlanId;
        this._string = null;
    }
    
    public VlanRef(String _string) {
        super();
        this._string = _string;
        this._vlanId = null;
    }
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public VlanRef(VlanRef source) {
        this._vlanId = source._vlanId;
        this._string = source._string;
    }
    
    /**
     * Return a String representing the value of this union.
     *
     * @return String representation of this union's value.
     */
    public String stringValue() {
        if (_vlanId != null) {
            return _vlanId.getValue().toString();
        }
        if (_string != null) {
            return _string;
        }
    
        throw new IllegalStateException("No value assinged");
    }


    public VlanId getVlanId() {
        return _vlanId;
    }
    
    public String getString() {
        return _string;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_vlanId);
        result = prime * result + Objects.hashCode(_string);
        return result;
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VlanRef)) {
            return false;
        }
        final VlanRef other = (VlanRef) obj;
        if (!Objects.equals(_vlanId, other._vlanId)) {
            return false;
        }
        if (!Objects.equals(_string, other._string)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(VlanRef.class);
        CodeHelpers.appendValue(helper, "_vlanId", _vlanId);
        CodeHelpers.appendValue(helper, "_string", _string);
        return helper.toString();
    }
}

