package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanMembersState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.members.state.Members;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.vlan.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.vlan.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Vlan} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Vlan createVlan(int fooXyzzy, int barBaz) {
 *         return new VlanBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Vlan, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Vlan
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class VlanBuilder implements Builder<Vlan> {

    private Config _config;
    private Members _members;
    private State _state;
    private VlanId _vlanId;
    private VlanKey key;


    Map<Class<? extends Augmentation<Vlan>>, Augmentation<Vlan>> augmentation = Collections.emptyMap();

    public VlanBuilder() {
    }
    
    
    
    public VlanBuilder(VlanMembersState arg) {
        this._members = arg.getMembers();
    }
    

    public VlanBuilder(Vlan base) {
        Map<Class<? extends Augmentation<Vlan>>, Augmentation<Vlan>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._vlanId = base.getVlanId();
        this._config = base.getConfig();
        this._members = base.getMembers();
        this._state = base.getState();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>VlanMembersState</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanMembersState) {
            this._members = ((VlanMembersState)arg).getMembers();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[VlanMembersState]");
    }

    public VlanKey key() {
        return key;
    }
    
    public Config getConfig() {
        return _config;
    }
    
    public Members getMembers() {
        return _members;
    }
    
    public State getState() {
        return _state;
    }
    
    public VlanId getVlanId() {
        return _vlanId;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Vlan>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public VlanBuilder withKey(final VlanKey key) {
        this.key = key;
        return this;
    }
    
    public VlanBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    public VlanBuilder setMembers(final Members value) {
        this._members = value;
        return this;
    }
    
    public VlanBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    public VlanBuilder setVlanId(final VlanId value) {
        this._vlanId = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public VlanBuilder addAugmentation(Augmentation<Vlan> augmentation) {
        Class<? extends Augmentation<Vlan>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public VlanBuilder removeAugmentation(Class<? extends Augmentation<Vlan>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Vlan build() {
        return new VlanImpl(this);
    }

    private static final class VlanImpl
        extends AbstractAugmentable<Vlan>
        implements Vlan {
    
        private final Config _config;
        private final Members _members;
        private final State _state;
        private final VlanId _vlanId;
        private final VlanKey key;
    
        VlanImpl(VlanBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new VlanKey(base.getVlanId());
            }
            this._vlanId = key.getVlanId();
            this._config = base.getConfig();
            this._members = base.getMembers();
            this._state = base.getState();
        }
    
        @Override
        public VlanKey key() {
            return key;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public Members getMembers() {
            return _members;
        }
        
        @Override
        public State getState() {
            return _state;
        }
        
        @Override
        public VlanId getVlanId() {
            return _vlanId;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Vlan.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Vlan.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Vlan.bindingToString(this);
        }
    }
}
