package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.members.state;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanMembersState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.members.state.members.Member;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container for list of member interfaces
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * container members {
 *   list member {
 *     config false;
 *     uses oc-if:base-interface-ref-state;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-vlanvlan-members-statemembers</i>
 *
 * <p>To create instances of this class use {@link MembersBuilder}.
 * @see MembersBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Members
    extends
    ChildOf<VlanMembersState>,
    Augmentable<Members>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("members");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.members.state.Members> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.members.state.Members.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.members.state.@NonNull Members obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getMember());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.members.state.@NonNull Members thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.members.state.Members other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.members.state.Members.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getMember(), other.getMember())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.members.state.@NonNull Members obj) {
        final var helper = MoreObjects.toStringHelper("Members");
        CodeHelpers.appendValue(helper, "member", obj.getMember());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return member, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of references to interfaces / subinterfaces associated with the VLAN.
     *     </code>
     * </pre>
     *
     * @return {@code List<Member>} member, or {@code null} if it is not present.
     *
     */
    @Nullable List<Member> getMember();
    
    /**
     * Return member, or an empty list if it is not present.
     *
     * @return {@code List<Member>} member, or an empty list if it is not present.
     *
     */
    default @NonNull List<Member> nonnullMember() {
        return CodeHelpers.nonnull(getMember());
    }

}

