package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.DoubleTagged;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.DoubleTaggedInnerList;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.DoubleTaggedInnerOuterRange;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.DoubleTaggedInnerRange;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.DoubleTaggedOuterList;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.DoubleTaggedOuterRange;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.SingleTagged;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.SingleTaggedList;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.SingleTaggedRange;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Match} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Match createMatch(int fooXyzzy, int barBaz) {
 *         return new MatchBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Match, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Match
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class MatchBuilder implements Builder<Match> {

    private DoubleTagged _doubleTagged;
    private DoubleTaggedInnerList _doubleTaggedInnerList;
    private DoubleTaggedInnerOuterRange _doubleTaggedInnerOuterRange;
    private DoubleTaggedInnerRange _doubleTaggedInnerRange;
    private DoubleTaggedOuterList _doubleTaggedOuterList;
    private DoubleTaggedOuterRange _doubleTaggedOuterRange;
    private SingleTagged _singleTagged;
    private SingleTaggedList _singleTaggedList;
    private SingleTaggedRange _singleTaggedRange;


    Map<Class<? extends Augmentation<Match>>, Augmentation<Match>> augmentation = Collections.emptyMap();

    public MatchBuilder() {
    }
    
    

    public MatchBuilder(Match base) {
        Map<Class<? extends Augmentation<Match>>, Augmentation<Match>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._doubleTagged = base.getDoubleTagged();
        this._doubleTaggedInnerList = base.getDoubleTaggedInnerList();
        this._doubleTaggedInnerOuterRange = base.getDoubleTaggedInnerOuterRange();
        this._doubleTaggedInnerRange = base.getDoubleTaggedInnerRange();
        this._doubleTaggedOuterList = base.getDoubleTaggedOuterList();
        this._doubleTaggedOuterRange = base.getDoubleTaggedOuterRange();
        this._singleTagged = base.getSingleTagged();
        this._singleTaggedList = base.getSingleTaggedList();
        this._singleTaggedRange = base.getSingleTaggedRange();
    }


    public DoubleTagged getDoubleTagged() {
        return _doubleTagged;
    }
    
    public DoubleTaggedInnerList getDoubleTaggedInnerList() {
        return _doubleTaggedInnerList;
    }
    
    public DoubleTaggedInnerOuterRange getDoubleTaggedInnerOuterRange() {
        return _doubleTaggedInnerOuterRange;
    }
    
    public DoubleTaggedInnerRange getDoubleTaggedInnerRange() {
        return _doubleTaggedInnerRange;
    }
    
    public DoubleTaggedOuterList getDoubleTaggedOuterList() {
        return _doubleTaggedOuterList;
    }
    
    public DoubleTaggedOuterRange getDoubleTaggedOuterRange() {
        return _doubleTaggedOuterRange;
    }
    
    public SingleTagged getSingleTagged() {
        return _singleTagged;
    }
    
    public SingleTaggedList getSingleTaggedList() {
        return _singleTaggedList;
    }
    
    public SingleTaggedRange getSingleTaggedRange() {
        return _singleTaggedRange;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Match>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public MatchBuilder setDoubleTagged(final DoubleTagged value) {
        this._doubleTagged = value;
        return this;
    }
    
    public MatchBuilder setDoubleTaggedInnerList(final DoubleTaggedInnerList value) {
        this._doubleTaggedInnerList = value;
        return this;
    }
    
    public MatchBuilder setDoubleTaggedInnerOuterRange(final DoubleTaggedInnerOuterRange value) {
        this._doubleTaggedInnerOuterRange = value;
        return this;
    }
    
    public MatchBuilder setDoubleTaggedInnerRange(final DoubleTaggedInnerRange value) {
        this._doubleTaggedInnerRange = value;
        return this;
    }
    
    public MatchBuilder setDoubleTaggedOuterList(final DoubleTaggedOuterList value) {
        this._doubleTaggedOuterList = value;
        return this;
    }
    
    public MatchBuilder setDoubleTaggedOuterRange(final DoubleTaggedOuterRange value) {
        this._doubleTaggedOuterRange = value;
        return this;
    }
    
    public MatchBuilder setSingleTagged(final SingleTagged value) {
        this._singleTagged = value;
        return this;
    }
    
    public MatchBuilder setSingleTaggedList(final SingleTaggedList value) {
        this._singleTaggedList = value;
        return this;
    }
    
    public MatchBuilder setSingleTaggedRange(final SingleTaggedRange value) {
        this._singleTaggedRange = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MatchBuilder addAugmentation(Augmentation<Match> augmentation) {
        Class<? extends Augmentation<Match>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MatchBuilder removeAugmentation(Class<? extends Augmentation<Match>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Match build() {
        return new MatchImpl(this);
    }

    private static final class MatchImpl
        extends AbstractAugmentable<Match>
        implements Match {
    
        private final DoubleTagged _doubleTagged;
        private final DoubleTaggedInnerList _doubleTaggedInnerList;
        private final DoubleTaggedInnerOuterRange _doubleTaggedInnerOuterRange;
        private final DoubleTaggedInnerRange _doubleTaggedInnerRange;
        private final DoubleTaggedOuterList _doubleTaggedOuterList;
        private final DoubleTaggedOuterRange _doubleTaggedOuterRange;
        private final SingleTagged _singleTagged;
        private final SingleTaggedList _singleTaggedList;
        private final SingleTaggedRange _singleTaggedRange;
    
        MatchImpl(MatchBuilder base) {
            super(base.augmentation);
            this._doubleTagged = base.getDoubleTagged();
            this._doubleTaggedInnerList = base.getDoubleTaggedInnerList();
            this._doubleTaggedInnerOuterRange = base.getDoubleTaggedInnerOuterRange();
            this._doubleTaggedInnerRange = base.getDoubleTaggedInnerRange();
            this._doubleTaggedOuterList = base.getDoubleTaggedOuterList();
            this._doubleTaggedOuterRange = base.getDoubleTaggedOuterRange();
            this._singleTagged = base.getSingleTagged();
            this._singleTaggedList = base.getSingleTaggedList();
            this._singleTaggedRange = base.getSingleTaggedRange();
        }
    
        @Override
        public DoubleTagged getDoubleTagged() {
            return _doubleTagged;
        }
        
        @Override
        public DoubleTaggedInnerList getDoubleTaggedInnerList() {
            return _doubleTaggedInnerList;
        }
        
        @Override
        public DoubleTaggedInnerOuterRange getDoubleTaggedInnerOuterRange() {
            return _doubleTaggedInnerOuterRange;
        }
        
        @Override
        public DoubleTaggedInnerRange getDoubleTaggedInnerRange() {
            return _doubleTaggedInnerRange;
        }
        
        @Override
        public DoubleTaggedOuterList getDoubleTaggedOuterList() {
            return _doubleTaggedOuterList;
        }
        
        @Override
        public DoubleTaggedOuterRange getDoubleTaggedOuterRange() {
            return _doubleTaggedOuterRange;
        }
        
        @Override
        public SingleTagged getSingleTagged() {
            return _singleTagged;
        }
        
        @Override
        public SingleTaggedList getSingleTaggedList() {
            return _singleTaggedList;
        }
        
        @Override
        public SingleTaggedRange getSingleTaggedRange() {
            return _singleTaggedRange;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Match.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Match.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Match.bindingToString(this);
        }
    }
}
