package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Specifies single-tagged packets with a list of VLAN identifiers.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-single-tagged-list-config {
 *   leaf-list vlan-ids {
 *     type oc-vlan-types:vlan-id;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-vlanvlan-logical-single-tagged-list-config</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalSingleTaggedListConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-logical-single-tagged-list-config");

    @Override
    Class<? extends VlanLogicalSingleTaggedListConfig> implementedInterface();
    
    /**
     * Return vlanIds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         VLAN identifiers for single-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code List<VlanId>} vlanIds, or {@code null} if it is not present.
     *
     */
    @Nullable List<VlanId> getVlanIds();
    
    /**
     * Return vlanIds, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         VLAN identifiers for single-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code List<VlanId>} vlanIds, guaranteed to be non-null.
     * @throws NoSuchElementException if vlanIds is not present
     *
     */
    default @NonNull List<VlanId> requireVlanIds() {
        return CodeHelpers.require(getVlanIds(), "vlanids");
    }

}

