package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Specifies double-tagged packets with an inner exact and outer list of VLAN 
 * identifiers.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-double-tagged-outer-list-config {
 *   leaf inner-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf-list outer-vlan-ids {
 *     type oc-vlan-types:vlan-id;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-vlanvlan-logical-double-tagged-outer-list-config</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalDoubleTaggedOuterListConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-logical-double-tagged-outer-list-config");

    @Override
    Class<? extends VlanLogicalDoubleTaggedOuterListConfig> implementedInterface();
    
    /**
     * Return innerVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Inner VLAN identifier for double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} innerVlanId, or {@code null} if it is not present.
     *
     */
    VlanId getInnerVlanId();
    
    /**
     * Return innerVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Inner VLAN identifier for double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} innerVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if innerVlanId is not present
     *
     */
    default @NonNull VlanId requireInnerVlanId() {
        return CodeHelpers.require(getInnerVlanId(), "innervlanid");
    }
    
    /**
     * Return outerVlanIds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Outer VLAN identifiers for double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code List<VlanId>} outerVlanIds, or {@code null} if it is not present.
     *
     */
    @Nullable List<VlanId> getOuterVlanIds();
    
    /**
     * Return outerVlanIds, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Outer VLAN identifiers for double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code List<VlanId>} outerVlanIds, guaranteed to be non-null.
     * @throws NoSuchElementException if outerVlanIds is not present
     *
     */
    default @NonNull List<VlanId> requireOuterVlanIds() {
        return CodeHelpers.require(getOuterVlanIds(), "outervlanids");
    }

}

