package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * VLAN configuration container.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-config {
 *   leaf vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf name {
 *     type string;
 *   }
 *   leaf status {
 *     type enumeration {
 *       enum ACTIVE {
 *       }
 *       enum SUSPENDED {
 *       }
 *     }
 *     default ACTIVE;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-vlanvlan-config</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanConfig
    extends
    DataObject
{


    @Generated("mdsal-binding-generator")
    public enum Status implements Enumeration {
        /**
         * VLAN is active
         */
        ACTIVE(0, "ACTIVE"),
        
        /**
         * VLAN is inactive / suspended
         */
        SUSPENDED(1, "SUSPENDED")
        ;
    
        private static final Map<String, Status> NAME_MAP;
        private static final Map<Integer, Status> VALUE_MAP;
    
        static {
            final Builder<String, Status> nb = ImmutableMap.builder();
            final Builder<Integer, Status> vb = ImmutableMap.builder();
            for (Status enumItem : Status.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private Status(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding Status item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<Status> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Status item, or null if no such item exists
         */
        public static Status forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-config");

    @Override
    Class<? extends VlanConfig> implementedInterface();
    
    /**
     * Return vlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Interface VLAN id.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} vlanId, or {@code null} if it is not present.
     *
     */
    VlanId getVlanId();
    
    /**
     * Return vlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Interface VLAN id.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} vlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if vlanId is not present
     *
     */
    default @NonNull VlanId requireVlanId() {
        return CodeHelpers.require(getVlanId(), "vlanid");
    }
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Interface VLAN name.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Interface VLAN name.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return status, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Admin state of the VLAN
     *     </code>
     * </pre>
     *
     * @return {@code Status} status, or {@code null} if it is not present.
     *
     */
    Status getStatus();
    
    /**
     * Return status, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Admin state of the VLAN
     *     </code>
     * </pre>
     *
     * @return {@code Status} status, guaranteed to be non-null.
     * @throws NoSuchElementException if status is not present
     *
     */
    default @NonNull Status requireStatus() {
        return CodeHelpers.require(getStatus(), "status");
    }

}

