package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemGlobalConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.DomainName;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Config} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Config createConfig(int fooXyzzy, int barBaz) {
 *         return new ConfigBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Config, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Config
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class ConfigBuilder implements Builder<Config> {

    private DomainName _domainName;
    private DomainName _hostname;
    private String _loginBanner;
    private String _motdBanner;


    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }
    
    
    
    public ConfigBuilder(SystemGlobalConfig arg) {
        this._hostname = arg.getHostname();
        this._domainName = arg.getDomainName();
        this._loginBanner = arg.getLoginBanner();
        this._motdBanner = arg.getMotdBanner();
    }

    public ConfigBuilder(Config base) {
        Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._domainName = base.getDomainName();
        this._hostname = base.getHostname();
        this._loginBanner = base.getLoginBanner();
        this._motdBanner = base.getMotdBanner();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>SystemGlobalConfig</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemGlobalConfig) {
            this._hostname = ((SystemGlobalConfig)arg).getHostname();
            this._domainName = ((SystemGlobalConfig)arg).getDomainName();
            this._loginBanner = ((SystemGlobalConfig)arg).getLoginBanner();
            this._motdBanner = ((SystemGlobalConfig)arg).getMotdBanner();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SystemGlobalConfig]");
    }

    public DomainName getDomainName() {
        return _domainName;
    }
    
    public DomainName getHostname() {
        return _hostname;
    }
    
    public String getLoginBanner() {
        return _loginBanner;
    }
    
    public String getMotdBanner() {
        return _motdBanner;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public ConfigBuilder setDomainName(final DomainName value) {
        this._domainName = value;
        return this;
    }
    
    public ConfigBuilder setHostname(final DomainName value) {
        this._hostname = value;
        return this;
    }
    
    public ConfigBuilder setLoginBanner(final String value) {
        this._loginBanner = value;
        return this;
    }
    
    public ConfigBuilder setMotdBanner(final String value) {
        this._motdBanner = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        Class<? extends Augmentation<Config>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
        extends AbstractAugmentable<Config>
        implements Config {
    
        private final DomainName _domainName;
        private final DomainName _hostname;
        private final String _loginBanner;
        private final String _motdBanner;
    
        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._domainName = base.getDomainName();
            this._hostname = base.getHostname();
            this._loginBanner = base.getLoginBanner();
            this._motdBanner = base.getMotdBanner();
        }
    
        @Override
        public DomainName getDomainName() {
            return _domainName;
        }
        
        @Override
        public DomainName getHostname() {
            return _hostname;
        }
        
        @Override
        public String getLoginBanner() {
            return _loginBanner;
        }
        
        @Override
        public String getMotdBanner() {
            return _motdBanner;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Config.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Config.bindingToString(this);
        }
    }
}
