package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.Aaa;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.AlarmsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.Alarms;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.LicenseTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.license.top.License;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.MessagesTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.top.Messages;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.LoggingTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.top.Logging;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.ProcmonProcessesTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.Processes;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemClockTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemMemoryTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.clock.top.Clock;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.Cpus;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.top.Dns;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.memory.top.Memory;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.Ntp;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemSshServerTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemTelnetServerTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.SshServer;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.telnet.server.top.TelnetServer;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link System} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     System createSystem(int fooXyzzy, int barBaz) {
 *         return new SystemBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of System, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see System
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class SystemBuilder implements Builder<System> {

    private Aaa _aaa;
    private Alarms _alarms;
    private Clock _clock;
    private Config _config;
    private Cpus _cpus;
    private Dns _dns;
    private License _license;
    private Logging _logging;
    private Memory _memory;
    private Messages _messages;
    private Ntp _ntp;
    private Processes _processes;
    private SshServer _sshServer;
    private State _state;
    private TelnetServer _telnetServer;


    Map<Class<? extends Augmentation<System>>, Augmentation<System>> augmentation = Collections.emptyMap();

    public SystemBuilder() {
    }
    
    
    
    public SystemBuilder(SystemClockTop arg) {
        this._clock = arg.getClock();
    }
    
    public SystemBuilder(SystemDnsTop arg) {
        this._dns = arg.getDns();
    }
    
    public SystemBuilder(SystemNtpTop arg) {
        this._ntp = arg.getNtp();
    }
    
    public SystemBuilder(SystemSshServerTop arg) {
        this._sshServer = arg.getSshServer();
    }
    
    public SystemBuilder(SystemTelnetServerTop arg) {
        this._telnetServer = arg.getTelnetServer();
    }
    
    public SystemBuilder(LoggingTop arg) {
        this._logging = arg.getLogging();
    }
    
    public SystemBuilder(AaaTop arg) {
        this._aaa = arg.getAaa();
    }
    
    public SystemBuilder(SystemMemoryTop arg) {
        this._memory = arg.getMemory();
    }
    
    public SystemBuilder(SystemCpuTop arg) {
        this._cpus = arg.getCpus();
    }
    
    public SystemBuilder(ProcmonProcessesTop arg) {
        this._processes = arg.getProcesses();
    }
    
    public SystemBuilder(AlarmsTop arg) {
        this._alarms = arg.getAlarms();
    }
    
    public SystemBuilder(MessagesTop arg) {
        this._messages = arg.getMessages();
    }
    
    public SystemBuilder(LicenseTop arg) {
        this._license = arg.getLicense();
    }

    public SystemBuilder(System base) {
        Map<Class<? extends Augmentation<System>>, Augmentation<System>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._aaa = base.getAaa();
        this._alarms = base.getAlarms();
        this._clock = base.getClock();
        this._config = base.getConfig();
        this._cpus = base.getCpus();
        this._dns = base.getDns();
        this._license = base.getLicense();
        this._logging = base.getLogging();
        this._memory = base.getMemory();
        this._messages = base.getMessages();
        this._ntp = base.getNtp();
        this._processes = base.getProcesses();
        this._sshServer = base.getSshServer();
        this._state = base.getState();
        this._telnetServer = base.getTelnetServer();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>SystemSshServerTop</li>
     * <li>MessagesTop</li>
     * <li>SystemDnsTop</li>
     * <li>SystemMemoryTop</li>
     * <li>SystemCpuTop</li>
     * <li>LoggingTop</li>
     * <li>SystemTelnetServerTop</li>
     * <li>AlarmsTop</li>
     * <li>ProcmonProcessesTop</li>
     * <li>SystemClockTop</li>
     * <li>SystemNtpTop</li>
     * <li>AaaTop</li>
     * <li>LicenseTop</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemSshServerTop) {
            this._sshServer = ((SystemSshServerTop)arg).getSshServer();
            isValidArg = true;
        }
        if (arg instanceof MessagesTop) {
            this._messages = ((MessagesTop)arg).getMessages();
            isValidArg = true;
        }
        if (arg instanceof SystemDnsTop) {
            this._dns = ((SystemDnsTop)arg).getDns();
            isValidArg = true;
        }
        if (arg instanceof SystemMemoryTop) {
            this._memory = ((SystemMemoryTop)arg).getMemory();
            isValidArg = true;
        }
        if (arg instanceof SystemCpuTop) {
            this._cpus = ((SystemCpuTop)arg).getCpus();
            isValidArg = true;
        }
        if (arg instanceof LoggingTop) {
            this._logging = ((LoggingTop)arg).getLogging();
            isValidArg = true;
        }
        if (arg instanceof SystemTelnetServerTop) {
            this._telnetServer = ((SystemTelnetServerTop)arg).getTelnetServer();
            isValidArg = true;
        }
        if (arg instanceof AlarmsTop) {
            this._alarms = ((AlarmsTop)arg).getAlarms();
            isValidArg = true;
        }
        if (arg instanceof ProcmonProcessesTop) {
            this._processes = ((ProcmonProcessesTop)arg).getProcesses();
            isValidArg = true;
        }
        if (arg instanceof SystemClockTop) {
            this._clock = ((SystemClockTop)arg).getClock();
            isValidArg = true;
        }
        if (arg instanceof SystemNtpTop) {
            this._ntp = ((SystemNtpTop)arg).getNtp();
            isValidArg = true;
        }
        if (arg instanceof AaaTop) {
            this._aaa = ((AaaTop)arg).getAaa();
            isValidArg = true;
        }
        if (arg instanceof LicenseTop) {
            this._license = ((LicenseTop)arg).getLicense();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SystemSshServerTop, MessagesTop, SystemDnsTop, SystemMemoryTop, SystemCpuTop, LoggingTop, SystemTelnetServerTop, AlarmsTop, ProcmonProcessesTop, SystemClockTop, SystemNtpTop, AaaTop, LicenseTop]");
    }

    public Aaa getAaa() {
        return _aaa;
    }
    
    public Alarms getAlarms() {
        return _alarms;
    }
    
    public Clock getClock() {
        return _clock;
    }
    
    public Config getConfig() {
        return _config;
    }
    
    public Cpus getCpus() {
        return _cpus;
    }
    
    public Dns getDns() {
        return _dns;
    }
    
    public License getLicense() {
        return _license;
    }
    
    public Logging getLogging() {
        return _logging;
    }
    
    public Memory getMemory() {
        return _memory;
    }
    
    public Messages getMessages() {
        return _messages;
    }
    
    public Ntp getNtp() {
        return _ntp;
    }
    
    public Processes getProcesses() {
        return _processes;
    }
    
    public SshServer getSshServer() {
        return _sshServer;
    }
    
    public State getState() {
        return _state;
    }
    
    public TelnetServer getTelnetServer() {
        return _telnetServer;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<System>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public SystemBuilder setAaa(final Aaa value) {
        this._aaa = value;
        return this;
    }
    
    public SystemBuilder setAlarms(final Alarms value) {
        this._alarms = value;
        return this;
    }
    
    public SystemBuilder setClock(final Clock value) {
        this._clock = value;
        return this;
    }
    
    public SystemBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    public SystemBuilder setCpus(final Cpus value) {
        this._cpus = value;
        return this;
    }
    
    public SystemBuilder setDns(final Dns value) {
        this._dns = value;
        return this;
    }
    
    public SystemBuilder setLicense(final License value) {
        this._license = value;
        return this;
    }
    
    public SystemBuilder setLogging(final Logging value) {
        this._logging = value;
        return this;
    }
    
    public SystemBuilder setMemory(final Memory value) {
        this._memory = value;
        return this;
    }
    
    public SystemBuilder setMessages(final Messages value) {
        this._messages = value;
        return this;
    }
    
    public SystemBuilder setNtp(final Ntp value) {
        this._ntp = value;
        return this;
    }
    
    public SystemBuilder setProcesses(final Processes value) {
        this._processes = value;
        return this;
    }
    
    public SystemBuilder setSshServer(final SshServer value) {
        this._sshServer = value;
        return this;
    }
    
    public SystemBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    public SystemBuilder setTelnetServer(final TelnetServer value) {
        this._telnetServer = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SystemBuilder addAugmentation(Augmentation<System> augmentation) {
        Class<? extends Augmentation<System>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SystemBuilder removeAugmentation(Class<? extends Augmentation<System>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public System build() {
        return new SystemImpl(this);
    }

    private static final class SystemImpl
        extends AbstractAugmentable<System>
        implements System {
    
        private final Aaa _aaa;
        private final Alarms _alarms;
        private final Clock _clock;
        private final Config _config;
        private final Cpus _cpus;
        private final Dns _dns;
        private final License _license;
        private final Logging _logging;
        private final Memory _memory;
        private final Messages _messages;
        private final Ntp _ntp;
        private final Processes _processes;
        private final SshServer _sshServer;
        private final State _state;
        private final TelnetServer _telnetServer;
    
        SystemImpl(SystemBuilder base) {
            super(base.augmentation);
            this._aaa = base.getAaa();
            this._alarms = base.getAlarms();
            this._clock = base.getClock();
            this._config = base.getConfig();
            this._cpus = base.getCpus();
            this._dns = base.getDns();
            this._license = base.getLicense();
            this._logging = base.getLogging();
            this._memory = base.getMemory();
            this._messages = base.getMessages();
            this._ntp = base.getNtp();
            this._processes = base.getProcesses();
            this._sshServer = base.getSshServer();
            this._state = base.getState();
            this._telnetServer = base.getTelnetServer();
        }
    
        @Override
        public Aaa getAaa() {
            return _aaa;
        }
        
        @Override
        public Alarms getAlarms() {
            return _alarms;
        }
        
        @Override
        public Clock getClock() {
            return _clock;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public Cpus getCpus() {
            return _cpus;
        }
        
        @Override
        public Dns getDns() {
            return _dns;
        }
        
        @Override
        public License getLicense() {
            return _license;
        }
        
        @Override
        public Logging getLogging() {
            return _logging;
        }
        
        @Override
        public Memory getMemory() {
            return _memory;
        }
        
        @Override
        public Messages getMessages() {
            return _messages;
        }
        
        @Override
        public Ntp getNtp() {
            return _ntp;
        }
        
        @Override
        public Processes getProcesses() {
            return _processes;
        }
        
        @Override
        public SshServer getSshServer() {
            return _sshServer;
        }
        
        @Override
        public State getState() {
            return _state;
        }
        
        @Override
        public TelnetServer getTelnetServer() {
            return _telnetServer;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = System.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return System.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return System.bindingToString(this);
        }
    }
}
