package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.ntp.keys.NtpKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.ntp.keys.NtpKeyKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link NtpKeys} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NtpKeys createNtpKeys(int fooXyzzy, int barBaz) {
 *         return new NtpKeysBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NtpKeys, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NtpKeys
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NtpKeysBuilder implements Builder<NtpKeys> {

    private Map<NtpKeyKey, NtpKey> _ntpKey;


    Map<Class<? extends Augmentation<NtpKeys>>, Augmentation<NtpKeys>> augmentation = Collections.emptyMap();

    public NtpKeysBuilder() {
    }
    
    

    public NtpKeysBuilder(NtpKeys base) {
        Map<Class<? extends Augmentation<NtpKeys>>, Augmentation<NtpKeys>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._ntpKey = base.getNtpKey();
    }


    public Map<NtpKeyKey, NtpKey> getNtpKey() {
        return _ntpKey;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NtpKeys>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NtpKeysBuilder setNtpKey(final Map<NtpKeyKey, NtpKey> values) {
        this._ntpKey = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NtpKeysBuilder addAugmentation(Augmentation<NtpKeys> augmentation) {
        Class<? extends Augmentation<NtpKeys>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NtpKeysBuilder removeAugmentation(Class<? extends Augmentation<NtpKeys>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NtpKeys build() {
        return new NtpKeysImpl(this);
    }

    private static final class NtpKeysImpl
        extends AbstractAugmentable<NtpKeys>
        implements NtpKeys {
    
        private final Map<NtpKeyKey, NtpKey> _ntpKey;
    
        NtpKeysImpl(NtpKeysBuilder base) {
            super(base.augmentation);
            this._ntpKey = CodeHelpers.emptyToNull(base.getNtpKey());
        }
    
        @Override
        public Map<NtpKeyKey, NtpKey> getNtpKey() {
            return _ntpKey;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NtpKeys.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NtpKeys.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NtpKeys.bindingToString(this);
        }
    }
}
