package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries.host.entry;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsStaticConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsStaticState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Ipv4Address;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Ipv6Address;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder implements Builder<State> {

    private List<String> _alias;
    private String _hostname;
    private List<Ipv4Address> _ipv4Address;
    private List<Ipv6Address> _ipv6Address;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }
    
    
    
    public StateBuilder(SystemDnsStaticConfig arg) {
        this._hostname = arg.getHostname();
        this._alias = arg.getAlias();
        this._ipv4Address = arg.getIpv4Address();
        this._ipv6Address = arg.getIpv6Address();
    }
    
    public StateBuilder(SystemDnsStaticState arg) {
    }

    public StateBuilder(State base) {
        Map<Class<? extends Augmentation<State>>, Augmentation<State>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._alias = base.getAlias();
        this._hostname = base.getHostname();
        this._ipv4Address = base.getIpv4Address();
        this._ipv6Address = base.getIpv6Address();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>SystemDnsStaticState</li>
     * <li>SystemDnsStaticConfig</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemDnsStaticState) {
            isValidArg = true;
        }
        if (arg instanceof SystemDnsStaticConfig) {
            this._hostname = ((SystemDnsStaticConfig)arg).getHostname();
            this._alias = ((SystemDnsStaticConfig)arg).getAlias();
            this._ipv4Address = ((SystemDnsStaticConfig)arg).getIpv4Address();
            this._ipv6Address = ((SystemDnsStaticConfig)arg).getIpv6Address();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SystemDnsStaticState, SystemDnsStaticConfig]");
    }

    public List<String> getAlias() {
        return _alias;
    }
    
    public String getHostname() {
        return _hostname;
    }
    
    public List<Ipv4Address> getIpv4Address() {
        return _ipv4Address;
    }
    
    public List<Ipv6Address> getIpv6Address() {
        return _ipv6Address;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setAlias(final List<String> values) {
        this._alias = values;
        return this;
    }
    
    
    public StateBuilder setHostname(final String value) {
        this._hostname = value;
        return this;
    }
    public StateBuilder setIpv4Address(final List<Ipv4Address> values) {
        this._ipv4Address = values;
        return this;
    }
    
    public StateBuilder setIpv6Address(final List<Ipv6Address> values) {
        this._ipv6Address = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class<? extends Augmentation<State>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final List<String> _alias;
        private final String _hostname;
        private final List<Ipv4Address> _ipv4Address;
        private final List<Ipv6Address> _ipv6Address;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._alias = base.getAlias();
            this._hostname = base.getHostname();
            this._ipv4Address = base.getIpv4Address();
            this._ipv6Address = base.getIpv6Address();
        }
    
        @Override
        public List<String> getAlias() {
            return _alias;
        }
        
        @Override
        public String getHostname() {
            return _hostname;
        }
        
        @Override
        public List<Ipv4Address> getIpv4Address() {
            return _ipv4Address;
        }
        
        @Override
        public List<Ipv6Address> getIpv6Address() {
            return _ipv6Address;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
