package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.cpu;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuState.Index;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.HardwareInterrupt;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Idle;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Kernel;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Nice;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.SoftwareInterrupt;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Total;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.User;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Wait;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder implements Builder<State> {

    private HardwareInterrupt _hardwareInterrupt;
    private Idle _idle;
    private Index _index;
    private Kernel _kernel;
    private Nice _nice;
    private SoftwareInterrupt _softwareInterrupt;
    private Total _total;
    private User _user;
    private Wait _wait;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }
    
    
    
    public StateBuilder(SystemCpuState arg) {
        this._index = arg.getIndex();
        this._total = arg.getTotal();
        this._user = arg.getUser();
        this._kernel = arg.getKernel();
        this._nice = arg.getNice();
        this._idle = arg.getIdle();
        this._wait = arg.getWait();
        this._hardwareInterrupt = arg.getHardwareInterrupt();
        this._softwareInterrupt = arg.getSoftwareInterrupt();
    }

    public StateBuilder(State base) {
        Map<Class<? extends Augmentation<State>>, Augmentation<State>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._hardwareInterrupt = base.getHardwareInterrupt();
        this._idle = base.getIdle();
        this._index = base.getIndex();
        this._kernel = base.getKernel();
        this._nice = base.getNice();
        this._softwareInterrupt = base.getSoftwareInterrupt();
        this._total = base.getTotal();
        this._user = base.getUser();
        this._wait = base.getWait();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>SystemCpuState</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemCpuState) {
            this._index = ((SystemCpuState)arg).getIndex();
            this._total = ((SystemCpuState)arg).getTotal();
            this._user = ((SystemCpuState)arg).getUser();
            this._kernel = ((SystemCpuState)arg).getKernel();
            this._nice = ((SystemCpuState)arg).getNice();
            this._idle = ((SystemCpuState)arg).getIdle();
            this._wait = ((SystemCpuState)arg).getWait();
            this._hardwareInterrupt = ((SystemCpuState)arg).getHardwareInterrupt();
            this._softwareInterrupt = ((SystemCpuState)arg).getSoftwareInterrupt();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SystemCpuState]");
    }

    public HardwareInterrupt getHardwareInterrupt() {
        return _hardwareInterrupt;
    }
    
    public Idle getIdle() {
        return _idle;
    }
    
    public Index getIndex() {
        return _index;
    }
    
    public Kernel getKernel() {
        return _kernel;
    }
    
    public Nice getNice() {
        return _nice;
    }
    
    public SoftwareInterrupt getSoftwareInterrupt() {
        return _softwareInterrupt;
    }
    
    public Total getTotal() {
        return _total;
    }
    
    public User getUser() {
        return _user;
    }
    
    public Wait getWait() {
        return _wait;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public StateBuilder setHardwareInterrupt(final HardwareInterrupt value) {
        this._hardwareInterrupt = value;
        return this;
    }
    
    public StateBuilder setIdle(final Idle value) {
        this._idle = value;
        return this;
    }
    
    public StateBuilder setIndex(final Index value) {
        this._index = value;
        return this;
    }
    
    public StateBuilder setKernel(final Kernel value) {
        this._kernel = value;
        return this;
    }
    
    public StateBuilder setNice(final Nice value) {
        this._nice = value;
        return this;
    }
    
    public StateBuilder setSoftwareInterrupt(final SoftwareInterrupt value) {
        this._softwareInterrupt = value;
        return this;
    }
    
    public StateBuilder setTotal(final Total value) {
        this._total = value;
        return this;
    }
    
    public StateBuilder setUser(final User value) {
        this._user = value;
        return this;
    }
    
    public StateBuilder setWait(final Wait value) {
        this._wait = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class<? extends Augmentation<State>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final HardwareInterrupt _hardwareInterrupt;
        private final Idle _idle;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuState.Index _index;
        private final Kernel _kernel;
        private final Nice _nice;
        private final SoftwareInterrupt _softwareInterrupt;
        private final Total _total;
        private final User _user;
        private final Wait _wait;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._hardwareInterrupt = base.getHardwareInterrupt();
            this._idle = base.getIdle();
            this._index = base.getIndex();
            this._kernel = base.getKernel();
            this._nice = base.getNice();
            this._softwareInterrupt = base.getSoftwareInterrupt();
            this._total = base.getTotal();
            this._user = base.getUser();
            this._wait = base.getWait();
        }
    
        @Override
        public HardwareInterrupt getHardwareInterrupt() {
            return _hardwareInterrupt;
        }
        
        @Override
        public Idle getIdle() {
            return _idle;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuState.Index getIndex() {
            return _index;
        }
        
        @Override
        public Kernel getKernel() {
            return _kernel;
        }
        
        @Override
        public Nice getNice() {
            return _nice;
        }
        
        @Override
        public SoftwareInterrupt getSoftwareInterrupt() {
            return _softwareInterrupt;
        }
        
        @Override
        public Total getTotal() {
            return _total;
        }
        
        @Override
        public User getUser() {
            return _user;
        }
        
        @Override
        public Wait getWait() {
            return _wait;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
